import os

from crypta.profile.lib import date_helpers
from crypta.profile.tasks.monitoring.profiles.profiles_monitoring import ProfilesMonitoring
from crypta.profile.utils import luigi_utils
from crypta.profile.utils.config import config


class DailyCryptaidProfilesMonitoring(ProfilesMonitoring):
    name = 'crypta_cryptaid_profiles_log'
    solomon_metric_name = 'crypta_cryptaid_profiles'
    id_type = 'crypta_id'

    def requires(self):
        return {
            'Profiles': luigi_utils.ExternalInput(
                os.path.join(
                    config.CRYPTAID_PROFILES_EXPORT_DIRECTORY,
                    date_helpers.get_yesterday(self.date),
                ),
            ),
            'InfoTable': luigi_utils.ExternalInput(config.GEO_CRYPTA_ID),
            'Cleaner': luigi_utils.OldNodesByNameCleaner(
                self.date,
                folder=os.path.dirname(self.yt_folder),
                lifetime=5,
            ),
        }

    def update_coverage_in_lab(self, export_id, value, timestamp):
        pass

    def send_count_to_lab(self):
        pass
