import os

from crypta.profile.lib import date_helpers
from crypta.profile.tasks.monitoring.profiles.profiles_monitoring import ProfilesMonitoring
from crypta.profile.utils import (
    api,
    luigi_utils,
)
from crypta.profile.utils.config import config


class DailyYandexuidProfilesMonitoring(ProfilesMonitoring):
    name = 'crypta_yandexuid_profiles_log'
    solomon_metric_name = 'crypta_yandexuid_profiles'
    id_type = 'yandexuid'

    def requires(self):
        return {
            'Profiles': luigi_utils.ExternalInput(
                os.path.join(
                    config.YANDEXUID_PROFILES_EXPORT_DIRECTORY,
                    date_helpers.get_yesterday(self.date),
                ),
            ),
            'InfoTable': luigi_utils.ExternalInput(config.YUID_WITH_ALL_INFO_TABLE),
            'Cleaner': luigi_utils.OldNodesByNameCleaner(
                self.date,
                folder=os.path.dirname(self.yt_folder),
                lifetime=5,
            ),
        }

    def update_coverage_in_lab(self, export_id, value, timestamp):
        api.get_api().lab.updateExportProfilesCoverage(
            id=export_id,
            value=value,
            timestamp=timestamp,
        ).result()
