import os

from crypta.profile.tasks.monitoring.profiles.profiles_monitoring import ProfilesMonitoring
from crypta.profile.utils import luigi_utils
from crypta.profile.utils.config import config


class CryptaidProfilesFor14DaysMonitoring(ProfilesMonitoring):
    name = 'bb_storage_cryptaid'
    solomon_metric_name = 'crypta_cryptaid_profiles_for_14_days'
    id_type = 'crypta_id'

    def requires(self):
        return {
            'Profiles': luigi_utils.ExternalInputDate(
                config.CRYPTAID_EXPORT_PROFILES_14_DAYS_TABLE,
                self.date,
            ),
            'InfoTable': luigi_utils.ExternalInput(config.GEO_CRYPTA_ID),
            'Cleaner': luigi_utils.OldNodesByNameCleaner(
                self.date,
                folder=os.path.dirname(self.yt_folder),
                lifetime=5,
            ),
        }

    def update_coverage_in_lab(self, export_id, value, timestamp):
        pass

    def send_count_to_lab(self):
        pass
