import os

from crypta.profile.tasks.monitoring.profiles.profiles_monitoring import ProfilesMonitoring
from crypta.profile.utils import (
    api,
    luigi_utils,
)
from crypta.profile.utils.config import config


class YandexuidProfilesFor14DaysMonitoring(ProfilesMonitoring):
    name = 'bb_storage'
    solomon_metric_name = 'crypta_yandexuid_profiles_for_14_days'
    id_type = 'yandexuid'

    def requires(self):
        return {
            'Profiles': luigi_utils.ExternalInputDate(
                config.YANDEXUID_EXPORT_PROFILES_14_DAYS_TABLE,
                self.date,
            ),
            'InfoTable': luigi_utils.ExternalInput(config.YUID_WITH_ALL_INFO_TABLE),
            'Cleaner': luigi_utils.OldNodesByNameCleaner(
                self.date,
                folder=os.path.dirname(self.yt_folder),
                lifetime=5,
            ),
        }

    def update_coverage_in_lab(self, export_id, value, timestamp):
        api.get_api().lab.updateExportBigbCoverage(
            id=export_id,
            value=value,
            timestamp=timestamp,
        ).result()
