#!/usr/bin/python -tt
# -*- coding: utf-8 -*-

import os

import luigi

from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import (
    AttributeExternalInput,
    BaseYtTask,
    YtDailyRewritableTarget,
)
from crypta.siberia.bin.common.yt_describer.py import describe
from crypta.siberia.bin.common.yt_describer.proto.yt_describer_config_pb2 import TYtDescriberConfig


get_table_to_describe_query = """
INSERT INTO `{output_table}`
WITH TRUNCATE

SELECT
    yandexuid AS IdValue,
    'yandexuid' AS IdType,
    prism_segment AS GroupID
FROM `{input_table}`
WHERE yandexuid IS NOT NULL;
"""

add_new_stats_query = """
INSERT INTO `{all_stats_table}`

SELECT
    '{date}' || '-' || GroupID AS GroupID,
    Stats
FROM `{new_stats_table}`
ORDER BY GroupID;
"""


class PrismClustersDescriptionMonitoring(BaseYtTask):
    date = luigi.Parameter()
    juggler_host = config.CRYPTA_ML_JUGGLER_HOST
    task_group = 'monitoring'
    name = 'prism_clusters_description'

    def requires(self):
        return AttributeExternalInput(
            table=os.path.join(config.PRISM_OFFLINE_USER_WEIGHTS_DIR, self.date),
            attribute_name='stage',
            attribute_value='full',
        )

    def output(self):
        return YtDailyRewritableTarget(config.PRISM_CLUSTERS_STATS, self.date)

    def run(self):
        with self.yt.Transaction() as transaction, \
                self.yt.TempTable() as table_to_describe, \
                self.yt.TempTable() as clusters_stats:
            self.yql.query(
                get_table_to_describe_query.format(
                    input_table=self.input().table,
                    output_table=table_to_describe,
                ),
                transaction=transaction,
            )

            self.yt.create_empty_table(
                clusters_stats,
                schema={
                    'GroupID': 'string',
                    'Stats': 'string',
                },
            )

            segments_description_config = TYtDescriberConfig(
                CryptaIdUserDataTable=config.FOR_DESCRIPTION_BY_CRYPTAID_TABLE,
                TmpDir=config.PROFILES_TMP_YT_DIRECTORY,
                InputTable=table_to_describe,
                OutputTable=clusters_stats,
            )

            describe(self.yt, transaction, segments_description_config)

            self.yql.query(
                add_new_stats_query.format(
                    all_stats_table=self.output().table,
                    new_stats_table=clusters_stats,
                    date=self.date,
                ),
                transaction=transaction,
            )

            self.yt.set_attribute(
                self.output().table,
                'generate_date',
                self.date,
            )
