#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os

import luigi

from crypta.lib.python.juggler.juggler_helpers import report_event_to_juggler
from crypta.profile.lib import date_helpers
from crypta.profile.utils.config import config
from crypta.profile.utils.luigi_utils import (
    BaseYtTask,
    ExternalInput,
    YtNodeAttributeTarget,
    YtTarget,
)


class PrismOfflineWeightsFreshnessMonitoring(BaseYtTask):
    date = luigi.Parameter()
    juggler_host = config.CRYPTA_ML_JUGGLER_HOST
    task_group = 'monitoring'
    name = 'prism_offline_weights_freshness_monitoring'

    def requires(self):
        return ExternalInput(os.path.join(config.YANDEXUID_PROFILES_EXPORT_DIRECTORY, self.date))

    def output(self):
        return YtNodeAttributeTarget(
            path=config.PRISM_OFFLINE_USER_WEIGHTS_DIR,
            attribute_name=self.__class__.__name__,
            attribute_value=self.date,
        )

    def report_outdated(self):
        service_name = 'outdated_prism_offline_weights'

        table_name = os.path.join(config.PRISM_OFFLINE_USER_WEIGHTS_DIR, date_helpers.get_yesterday(self.date))

        if not YtTarget(table_name).exists():
            message = 'Outdated table: {}'.format(table_name)
            self.logger.info(message)
            report_event_to_juggler(
                status='WARN',
                service=service_name,
                host=config.CRYPTA_ML_JUGGLER_HOST,
                description=message,
                logger=self.logger,
            )
        else:
            self.logger.info('All tables up to date')
            report_event_to_juggler(
                status='OK',
                service=service_name,
                host=config.CRYPTA_ML_JUGGLER_HOST,
                logger=self.logger,
            )

    def run(self):
        self.report_outdated()

        self.yt.set_attribute(
            self.output().path,
            self.__class__.__name__,
            self.date,
        )
