#!/usr/bin/env python
# -*- coding: utf-8 -*-

calculate_stats_query_template = """
$input_table = '{input_table}';

${segment_type}_stat = (
    SELECT 'total' AS {segment_type},
        COUNT_IF(validation_{segment_type} == predicted_{segment_type}) AS intersection_count,
        COUNT(*) AS crypta_count,
        1.0 * COUNT_IF(validation_{segment_type} == predicted_{segment_type}) / COUNT(*) AS precision
    FROM $input_table
    WHERE validation_{segment_type} is not Null AND predicted_{segment_type} is not Null
    UNION ALL
    SELECT predicted_{segment_type} AS {segment_type},
        COUNT_IF(validation_{segment_type} == predicted_{segment_type}) AS intersection_count,
        COUNT(*) AS crypta_count,
        1.0 * COUNT_IF(validation_{segment_type} == predicted_{segment_type}) / COUNT(*) AS precision
    FROM $input_table
    WHERE validation_{segment_type} is not Null AND predicted_{segment_type} is not Null
    GROUP BY predicted_{segment_type}
);

${segment_type}_validation_count = (
    SELECT 'total' AS {segment_type},
        COUNT(*) AS validation_count
    FROM $input_table
    WHERE validation_{segment_type} is not Null
    UNION ALL
    SELECT validation_{segment_type} AS {segment_type},
        COUNT(*) AS validation_count
    FROM $input_table
    WHERE validation_{segment_type} is not Null
    GROUP BY validation_{segment_type}
);

INSERT INTO `{output_table}` WITH TRUNCATE
SELECT t1.{segment_type} AS {segment_type},
    t1.intersection_count AS intersection_count,
    t1.crypta_count AS crypta_count,
    t1.precision AS precision,
    t2.validation_count AS validation_count
FROM ${segment_type}_stat AS t1
INNER JOIN ${segment_type}_validation_count AS t2
USING({segment_type})
ORDER BY {segment_type};
"""

calculate_max_update_time = """
$max_update_time = (
    SELECT MAX(update_time)
    FROM `{profiles_table}`
);
"""
