#!/usr/bin/python -tt
# -*- coding: utf-8 -*-
import os
import threading

from crypta.lib.python.swagger import swagger

from crypta.profile.utils.config import config
from crypta.profile.utils.config.secrets import get_secrets


API_SINGLETON = {}
CRYPTA_API_URL = {
    'testing': 'https://api-test.crypta.yandex.net/swagger.json',
    'production': 'https://api.crypta.yandex.net/swagger.json',
}


def get_api(env=None):
    pid = (os.getpid(), threading.current_thread().ident)
    env = env or config.environment
    global API_SINGLETON
    if (pid, env) in API_SINGLETON:
        return API_SINGLETON[(pid, env)]

    API_SINGLETON[(pid, env)] = swagger(
        CRYPTA_API_URL[env],
        get_secrets().get_secret('ROBOT_SECRETARY_OAUTH_TOKEN'),
    )

    return API_SINGLETON[(pid, env)]
