#!/usr/bin/python -tt
# -*- coding: utf-8 -*-

from collections import defaultdict

from crypta.profile.utils.api import get_api


def get_not_exported_segments():
    exports = get_api().lab.getNotExportedToBigB().result()
    segment_ids_by_keyword_id = defaultdict(set)

    for export in exports:
        segment_ids_by_keyword_id[export.keywordId].add(export.segmentId)

    return segment_ids_by_keyword_id


def get_trainable_segments():
    segments = get_api().lab.getAllSegments().result()
    trainable_segments_ids = set()
    for segment in segments:
        for export in segment.exports.exports:
            if export.keywordId == 546 and 'trainable' in export.tags:
                trainable_segments_ids.add(str(export.segmentId))
    return trainable_segments_ids
