#!/usr/bin/env python
# -*- coding: utf-8 -*-

from urlparse import urljoin

from crypta.lib.python.retryable_http_client import RetryableHttpClient, RetryableHttpClientError
from crypta.profile.utils.config.secrets import get_secrets

SOLOMON_RETRIES = 3
SOLOMON_DELAY = 3
SOLOMON_URL = 'http://solomon.yandex.net'
SENSOR_BATCH_SIZE = 5000


class SolomonClient(RetryableHttpClient):
    def __init__(self, api_url=SOLOMON_URL, delay=SOLOMON_DELAY, n_retries=SOLOMON_RETRIES,
                 oauth_token=None, logger=None):
        super(SolomonClient, self).__init__(n_retries, delay)
        self.oauth_token = oauth_token or get_secrets().get_secret('SOLOMON_OAUTH')
        self.api_url = api_url
        self.logger = logger

    def push_sensor_batch(self, project, cluster, service, common_labels, sensors):
        return self._make_request_with_retries(
            'POST',
            urljoin(self.api_url, 'api/v2/push'),
            headers={
                'Authorization': 'OAuth {}'.format(self.oauth_token),
            },
            params={
                'project': project,
                'cluster': cluster,
                'service': service,
            },
            json={
                'commonLabels': common_labels,
                'sensors': sensors,
            },
        )

    def push_sensors(self, project, cluster, service, common_labels, sensors):
        while sensors:
            try:
                self.push_sensor_batch(project, cluster, service, common_labels, sensors[:SENSOR_BATCH_SIZE])
            except RetryableHttpClientError as error:
                self.logger.exception(error.message)

            sensors = sensors[SENSOR_BATCH_SIZE:]
