#!/usr/bin/env python
# -*- coding: utf-8 -*-

from os.path import join

from crypta.profile.utils.config.environment import environment

# yt hack -- do not remove
import crypta.profile.utils.config.testing_config  # noqa
import crypta.profile.utils.config.production_config  # noqa


if environment == 'production':
    from crypta.profile.utils.config.production_config import *  # noqa
    from crypta.profile.utils.config.production_config import (
        CRYPTA_YT_WORKING_DIR,
        NUMBER_OF_DAYS_TO_CALCULATE_RULES,
    )
else:
    from crypta.profile.utils.config.testing_config import *  # noqa
    from crypta.profile.utils.config.testing_config import (
        CRYPTA_YT_WORKING_DIR,
        NUMBER_OF_DAYS_TO_CALCULATE_RULES,
    )

CRYPTA_YT_PROXY = 'hahn'
CRYPTA_AUDIENCE_LOGIN = 'ya.crypta'
CHYT_ALIAS = '*crypta'
YT_OPERATION_OWNERS = ["crypta-team"]

LOGBROKER_HOSTNAME = 'logbroker.yandex.net'
LOGBROKER_PORT = 2135
LOGBROKER_UPLOAD_JOB_COUNT_MULTIPLIER = 3
LOGBROKER_UPLOAD_BATCH_DATA_SIZE_MEGABYTES = 256

UNICORN_AUDIENCE_TVM_ID = 2011936
CRYPTAIDOR_AUDIENCE_TVM_ID = 2020697

TESTING_SAMPLE_RATIO = 0.1
INCOME_SAMPLING_SIZE = 6*(10**5)

STANDARD_AGGREGATION_PERIOD = 35
TIME_TO_ACCOUNT_INCOME_INFO_FOR_VOTING_YEARS = 2

NUMBER_OF_HITS_TABLES_TO_KEEP = 180
NUMBER_OF_INTERMEDIATE_PROFILES_TABLES_TO_KEEP = 14
NUMBER_OF_DAYS_TO_KEEP_PARSED_LOGS = NUMBER_OF_DAYS_TO_CALCULATE_RULES + 2

MINIMUM_SITES = 3
MAXIMUM_SITES = 5000

CHEVENT_LOG_AGGREGATION_MONTH_COUNT = 6

# this value will allow to mimic rt behaviour better
SHORTTERM_INTERESTS_EXPIRE_DAYS = 4

VECTOR_SIZE = 512

RUSSIA_REGION_ID = 225
MOSCOW_REGION_ID = 213

MIN_LAL_SIZE = 250000
MAX_LAL_SIZE = 50000000

SAMPLED_LABELS_FOR_TRAINING_COUNT = 60000

MONITORING_TABLES_TTL_DAYS = 5

YANDEXUID = 'yandexuid'
CRYPTA_ID = 'crypta_id'

REGULAR_SEGMENTS = 'regular_segments'
TRAINABLE_SEGMENTS = 'trainable_segments'

CRYPTA_IDENTIFIERS_UDF_RESOURCE = 'CRYPTA_IDENTIFIERS_UDF'
BIGB_UDF_RESOURCE = 'BIGB_UDF'
CRYPTA_URL_UTILS_UDF_RESOURCE = 'CRYPTA_URL_UTILS_UDF'
UDF_CLUSTER = "hahn"
CRYPTA_URL_UTILS_UDF_URL = 'yt://hahn/home/crypta/public/udfs/stable/libcrypta_url_utils_udf.so'
CRYPTA_IDENTIFIERS_UDF_PATH = 'home/crypta/public/udfs/stable/libcrypta_identifier_udf.so'

JUGGLER_API_URL = 'http://juggler-push.search.yandex.net/events'

PERCENTILE_OF_VECTORS_UPDATE = 0.99

# orgvisits
ORG_VISITS_DIRECTORY = '//home/user_identification/orgvisits/prod/state/export'
ORG_VISITS_DEEP = '//home/user_identification/orgvisits/prod/state/heuristic_deep_uses_visits/v1.0.0'
ORG_VISITS_DEEP_V2 = '//home/user_identification/orgvisits/prod/state/heuristic_deep_uses_visits/v2.0.0'
ORG_VISITS_GEO = '//logs/geolocation-united-geolog/1d'

# spravochnik data
SPRAV_COMPANIES = '//home/sprav/altay/prod/snapshot/company'
SPRAV_RUBRICS = '//home/sprav/altay/prod/snapshot/rubric'
SPRAV_COMPANY_TO_OWNER = '//home/sprav/altay/prod/snapshot/company_to_owner'

AFISHA_TICKET_ORDER_LOG = '//statbox/prepared-data/afisha/tickets/orders'
AUTORU_FRONT_LOG_FOLDER = '//statbox/autoru-front-log'
KINOPOISK_FILM_GENRES = '//home/kinopoisk/ext/production/film_genres'
KINOPOISK_SERIALS = '//home/kinopoisk/ext/production/data_serial/episode_air_date'
MUSIC_STREAMS_LOG_FOLDER = '//home/music/music-streams-log'
MUSIC_LIKE_EVENTS_LOG_FOLDER = '//home/music/like-events'
MUSIC_TRACKS_METADATA = '//home/music-data/music-metadata-v2/tracks'
MUSIC_ALBUMS_METADATA = '//home/music-data/music-metadata-v2/albums'
TAXI_DATA_LOG = '//home/taxi-dwh/export/crypta_user_profile/taxi_user_profile/taxi_user_profile'
ALICE_DIALOG_LOGS = '//home/alice/dialog/prepared_logs_expboxes'
BS_CHEVENT_COOKED_LOG = '//statbox/cooked_logs/bs-chevent-cooked-log/v2/1d'

MARKET_LOG_FOLDER = '//home/market/production/mstat/logs'
MARKET_CPA_CLICKS_LOG_FOLDER = join(MARKET_LOG_FOLDER, 'market-cpa-clicks-log/1d')
MARKET_SHOW_LOG_FOLDER = join(MARKET_LOG_FOLDER, 'market-shows-log/1d')
REGULAR_MARKET_ANALYST = '//home/market/production/mstat/analyst/regular'
ONLINE_PURCHASES_MONTHLY_FOLDER = join(REGULAR_MARKET_ANALYST, 'ecom_sales_auto_ref_panel_filtered')
ONLINE_PURCHASES_AGGREGATED_LOG = '//home/market/production/analytics_platform/analyst/ecom_log/sales_no_external/master'
ALL_CLICKS_ONE_DAY_AGO = '//home/market/production/mstat/robot-yt-sender/all_clicks_orders_one_day_ago'
MODELS_INFO = '//home/market/production/mstat/dictionaries/models'
MARKET_SALES_NO_EXTERNAL_FOLDER = '//home/market/production/analytics_platform/ecom_log_v2/sales_no_external'
MARKET_TAKERATE_TABLE = '//home/market/production/analytics_platform/analyst/takerate/takerate_by_beru_smoothed'

LOGS_YT_DIRECTORY = '//home/logfeller/logs'

SOVETNIK_LOG_FOLDER = join(LOGS_YT_DIRECTORY, 'sovetnik-log/1d')
BS_WATCH_LOG_FOLDER = join(LOGS_YT_DIRECTORY, 'bs-watch-log/1d')
BEH_PROFILE_REGULAR_LOG_FOLDER = join(LOGS_YT_DIRECTORY, 'beh-profile-regular-log/1h')
BEH_PROFILE_HIT_LOG_FOLDER = join(LOGS_YT_DIRECTORY, 'beh-profile-hit-log/1h')
ADFOX_EVENT_LOG = join(LOGS_YT_DIRECTORY, 'adfox-event-log/1d')

# public metrika mobile logs
APPMETRICA_YANDEX_EVENTS_LOG_FOLDER = join(LOGS_YT_DIRECTORY, 'appmetrica-yandex-events/1d')
SUPERAPP_METRIKA_MOBILE_LOG_FOLDER = join(LOGS_YT_DIRECTORY, 'superapp-metrika-mobile-log/1d')
SUPERAPP_METRIKA_MOBILE_LOG_5MIN = join(LOGS_YT_DIRECTORY, 'superapp-metrika-mobile-log/stream/5min')
BROWSER_METRIKA_MOBILE_LOG_FOLDER = join(LOGS_YT_DIRECTORY, 'browser-metrika-mobile-log/1d')
BROWSER_METRIKA_MOBILE_LOG_5MIN = join(LOGS_YT_DIRECTORY, 'browser-metrika-mobile-log/stream/5min')

METRIKA_MOBILE_CLICKS_LOG_FOLDER = join(LOGS_YT_DIRECTORY, 'mobile-clicks-log/1d')
METRIKA_MOBILE_INSTALL_LOG_FOLDER = join(LOGS_YT_DIRECTORY, 'metrika-mobile-install-log/1d')

# private metrika mobile logs
METRIKA_MOBILE_CLICKS_PRIVATE_LOG_FOLDER = join(LOGS_YT_DIRECTORY, 'mobile-clicks-private-log/1d')
METRIKA_MOBILE_INSTALL_PRIVATE_LOG_FOLDER = join(LOGS_YT_DIRECTORY, 'metrika-mobile-install-private-log/1d')

PASSPORT_DUMP_DIRECTORY = '//home/passport/production/userdata'
SOCIALDB_DUMP_DIRECTORY = '//home/passport/production/socialism/crypta-dump'
DRIVE_DATA = '//home/carsharing/production/export/crypta/users'
VOICE_SOCDEM_SOURCE = '//home/voice-speechbase/uniproxy/biometry'
DIT_DATA_FOLDER = '//home/crypta/production/dmp/dmp-ditmsk/raw-schematized'
WATSON_VK_DATA = '//home/watson/parsers_data/ivndex_vk_com_20181128_1218_26c593/kwyt_full'

GEOCUBE_LOG_DIRECTORY = '//home/geosearch-prod/geocube/1d'
REQANS_LOG_DIRECTORY = '//home/logfeller/logs/search-proto-reqans-log/stream/5min'
METRICS_LOG_DIRECTORY = '//home/logfeller/logs/bs-watch-log/stream/5min'
BAR_LOG_DIRECTORY = '//home/logfeller/logs/bar-navig-log/stream/5min'

WEEKLY_GEO_FOLDER = '//home/user_identification/usergeo/production/v2/state/weekly-geo'

MOBILE_APPLICATIONS_DIR = '//home/extdata/mobile'

# edadeal
EDADEAL_RECEIPTS = '//home/edadeal/pg/cashback/check_items'
EDADEAL_RECEIPTS_SCANS = '//home/edadeal/cooked/flat-ng/items'
EDADEAL_ITEM_ATTRIBUTES = '//home/edadeal/cooked/butara/cheque_items'
EDADEAL_DEVICES = '//home/edadeal/cooked/REFs/devices/TOTAL'


# graph
CRYPTA_PUBLIC_MATCHING_DIR = '//home/crypta/public/matching/by_id'
MATCHING_AUTO_ID_TO_CRYPTA_ID = join(CRYPTA_PUBLIC_MATCHING_DIR, 'auto_id/crypta_id')
MATCHING_CRYPTA_ID_TO_PUID = join(CRYPTA_PUBLIC_MATCHING_DIR, 'crypta_id/puid')

CRYPTA_PUBLIC_IDS_STORAGE_DIR = '//home/crypta/public/ids_storage'

CRYPTA_GRAPH_SOUP_DIR = '//home/crypta/production/state/graph/v2/soup'
KINOPOISK_ID_TO_YANDEXUID = join(CRYPTA_GRAPH_SOUP_DIR, 'yandexuid_kp_id_kinopoisk_access')
EMAILS_TO_CLASSIFY = join(CRYPTA_GRAPH_SOUP_DIR, 'ids/email')

# TODO same?
CRYPTA_GRAPH_DICT_DIR = join(CRYPTA_YT_WORKING_DIR, 'state/graph/dicts')
YANDEXUID_TO_ICOOKIE = join(CRYPTA_GRAPH_DICT_DIR, 'yandexuid_to_icookie')
ICOOKIE_WL = '//home/crypta/public/matching/by_id/yandexuid/soup/icookie/cookie_wl'

APP_METRICA_MONTH = join(CRYPTA_PUBLIC_IDS_STORAGE_DIR, 'device_id/app_metrica_month')
DEV_HASH_MONTH = join(CRYPTA_PUBLIC_IDS_STORAGE_DIR, 'device_id/hash_month')

YUID_WITH_ALL_INFO_TABLE = join(CRYPTA_PUBLIC_IDS_STORAGE_DIR, 'yandexuid/yuid_with_all_info')
GAID_ETERNAL = join(CRYPTA_PUBLIC_IDS_STORAGE_DIR, 'gaid/eternal')
IDFA_ETERNAL = join(CRYPTA_PUBLIC_IDS_STORAGE_DIR, 'idfa/eternal')
GEO_CRYPTA_ID = join(CRYPTA_PUBLIC_IDS_STORAGE_DIR, 'crypta_id/regions')

MOBILE_DEV_INFO = join(CRYPTA_YT_WORKING_DIR, 'state/graph/{}/mobile/dev_info_yt')

# households
HOUSEHOLD_ENRICH_TABLE = join(CRYPTA_YT_WORKING_DIR, 'state/households_new/output/hh_enrich')
HOUSEHOLD_REVERSED_TABLE = join(CRYPTA_YT_WORKING_DIR, 'state/households_new/output/hh_reversed')
HOUSEHOLD_CRYPTA_ID_TO_HHID = join(CRYPTA_YT_WORKING_DIR, 'state/households_new/output/hh_crypta_id_reversed')

LOOKALIKE_DIRECTORY = join(CRYPTA_YT_WORKING_DIR, 'lookalike')
LOOKALIKE_VERSIONS_DIRECTORY = join(LOOKALIKE_DIRECTORY, 'versions')
REGULAR_LAL_INPUT_DIRECTORY = join(LOOKALIKE_DIRECTORY, 'input')
REGULAR_LAL_OUTPUT_DIRECTORY = join(LOOKALIKE_DIRECTORY, 'output')

LAB_DIRECTORY = join(CRYPTA_YT_WORKING_DIR, 'lab')
USER_DATA_TABLE = join(LAB_DIRECTORY, 'data/UserData')

PROFILES_YT_DIRECTORY = join(CRYPTA_YT_WORKING_DIR, 'profiles')
PROFILES_TMP_YT_DIRECTORY = join(PROFILES_YT_DIRECTORY, 'tmp')
PROFILES_YQL_TMP_YT_DIRECTORY = join(PROFILES_TMP_YT_DIRECTORY, 'yql')
PROFILES_TMP_WORD_RULES_YT_DIRECTORY = join(PROFILES_TMP_YT_DIRECTORY, 'word_rules')
PROFILES_TMP_WORD_RULES_YT_TTL_DAYS = 1

CRYPTA_MONITORING_FOLDER = join(PROFILES_YT_DIRECTORY, 'monitorings')
CHEVENT_LOG_STATS_DIRECTORY = join(CRYPTA_MONITORING_FOLDER, 'chevent_log')
PRISM_MONITORING_DIRECTORY = join(CRYPTA_MONITORING_FOLDER, 'prism')
PRISM_CHEVENT_LOG_DIRECTORY = join(PRISM_MONITORING_DIRECTORY, 'chevent_log')
PRISM_GMV_DIRECTORY = join(PRISM_MONITORING_DIRECTORY, 'gmv')
PRISM_YANDEX_GOOGLE_VISITS_DIRECTORY = join(PRISM_MONITORING_DIRECTORY, 'yandex_google_visits')
PRISM_QUALITY_DIRECTORY = join(PRISM_MONITORING_DIRECTORY, 'quality')
PRISM_CLUSTERS_STATS = join(PRISM_MONITORING_DIRECTORY, 'clusters_daily_stats')

# input data
PROFILES_INPUT_YT_DIRECTORY = join(PROFILES_YT_DIRECTORY, 'input-data')
YANDEXUID_METRICA_BROWSER_COUNTER_TABLE = join(PROFILES_INPUT_YT_DIRECTORY, 'yandexuid_metrica_browser_visitor_counter')
CRYPTA_ID_METRICA_BROWSER_COUNTER_TABLE = join(PROFILES_INPUT_YT_DIRECTORY, 'crypta_id_metrica_browser_visitor_counter')

PRESTABLE_CATEGORICAL_FEATURES_MATCHING_DIR = join(PROFILES_INPUT_YT_DIRECTORY, 'categorical_features_prestable')
CATEGORICAL_FEATURES_MATCHING_DIR = join(PROFILES_INPUT_YT_DIRECTORY, 'categorical_features')

APP_METRICA_DATA_DIRECTORY = join(PROFILES_INPUT_YT_DIRECTORY, 'app-metrica')
MOBILE_APP_CATEGORIES = join(APP_METRICA_DATA_DIRECTORY, 'mobile_app_categories')

APP_BY_DEVID_MONTHLY_TABLE = join(APP_METRICA_DATA_DIRECTORY, 'app_by_devid_monthly')
APP_BY_DEVID_DAILY_TABLE = join(APP_METRICA_DATA_DIRECTORY, 'app_by_devid_daily')
APP_IDF_TABLE = join(APP_METRICA_DATA_DIRECTORY, 'IDF')
DEVID_BY_APP_MONTHLY_TABLE = join(APP_METRICA_DATA_DIRECTORY, 'devid_by_app')

PARSED_LOGS_YT_DIRECTORY = join(PROFILES_INPUT_YT_DIRECTORY, 'parsed-logs')
RULE_INDICES_YT_DIRECTORY = join(PROFILES_INPUT_YT_DIRECTORY, 'rule-indices')
BROKEN_PARSED_LOGS_YT_DIRECTORY = join(PARSED_LOGS_YT_DIRECTORY, 'broken')

APP_METRICA_YANDEX_DAILY = '//logs/appmetrica-yandex-events/1d'
APPMETRICA_EXTERNAL_DAILY = join(LOGS_YT_DIRECTORY, 'appmetrica-external-events/1d')

# bb
BB_PARSED_DIR = join(PARSED_LOGS_YT_DIRECTORY, 'bb')

# reqans
REQANS_PARSED_DIR = join(PARSED_LOGS_YT_DIRECTORY, 'reqans')
REQANS_DIR = join(PROFILES_INPUT_YT_DIRECTORY, 'reqans')
REQANS_WORDS_INDEX_DIR = join(RULE_INDICES_YT_DIRECTORY, 'reqans-words')
REQANS_HOSTS_INDEX_DIR = join(RULE_INDICES_YT_DIRECTORY, 'reqans-hosts')

# metrics
METRICS_PARSED_DIR = join(PARSED_LOGS_YT_DIRECTORY, 'metrics')
METRICS_DIR = join(PROFILES_INPUT_YT_DIRECTORY, 'metrics')
METRICS_URLS_INDEX_DIR = join(RULE_INDICES_YT_DIRECTORY, 'metrics-urls')
METRICS_WORDS_INDEX_DIR = join(RULE_INDICES_YT_DIRECTORY, 'metrics-words')

METRICS_HITS_DIRECTORY = join(METRICS_DIR, 'hits')
METRICS_SESSIONS_DIRECTORY = join(METRICS_DIR, 'sessions')

METRICS_MERGED_REFERRERS_BY_YANDEXUID_TABLE = join(METRICS_DIR, 'merged_referrers_by_yandexuid')

YANDEXUID_METRICS_MERGED_HITS_TABLE = join(METRICS_DIR, 'yandexuid_merged_hits')
CRYPTA_ID_METRICS_MERGED_HITS_TABLE = join(METRICS_DIR, 'crypta_id_merged_hits')
YANDEXUID_METRICS_FLATTENED_HITS_TABLE = join(METRICS_DIR, 'yandexuid_flattened_hits')
CRYPTA_ID_METRICS_FLATTENED_HITS_TABLE = join(METRICS_DIR, 'crypta_id_flattened_hits')
YANDEXUID_METRICS_IDF_TABLE = join(METRICS_DIR, 'yandexuid_IDF')
CRYPTA_ID_METRICS_IDF_TABLE = join(METRICS_DIR, 'crypta_id_IDF')

YANDEXUID_METRICS_TOP_SITES = join(METRICS_DIR, 'yandexuid_top_sites')
CRYPTA_ID_METRICS_TOP_SITES = join(METRICS_DIR, 'crypta_id_top_sites')

METRICS_HOST_APP_SESSIONS_DIRECTORY = join(METRICS_DIR, 'host_app_sessions')
METRICS_SITE_COUNTER_TABLE = join(METRICS_DIR, 'site_counter')
METRICS_VECTORS_TABLE = join(METRICS_DIR, 'vectors')

# bar
BAR_PARSED_DIR = join(PARSED_LOGS_YT_DIRECTORY, 'bar')
BAR_DIR = join(PROFILES_INPUT_YT_DIRECTORY, 'bar')
BAR_URLS_INDEX_DIR = join(RULE_INDICES_YT_DIRECTORY, 'bar-urls')
BAR_WORDS_INDEX_DIR = join(RULE_INDICES_YT_DIRECTORY, 'bar-words')

BAR_HITS_DIRECTORY = join(BAR_DIR, 'hits')
BAR_SESSIONS_DIRECTORY = join(BAR_DIR, 'sessions')

YANDEXUID_BAR_MERGED_HITS_TABLE = join(BAR_DIR, 'yandexuid_merged_hits')
CRYPTA_ID_BAR_MERGED_HITS_TABLE = join(BAR_DIR, 'crypta_id_merged_hits')
YANDEXUID_BAR_FLATTENED_HITS_TABLE = join(BAR_DIR, 'yandexuid_flattened_hits')
CRYPTA_ID_BAR_FLATTENED_HITS_TABLE = join(BAR_DIR, 'crypta_id_flattened_hits')
YANDEXUID_BAR_IDF_TABLE = join(BAR_DIR, 'yandexuid_IDF')
CRYPTA_ID_BAR_IDF_TABLE = join(BAR_DIR, 'crypta_id_IDF')

YANDEXUID_BAR_TOP_SITES = join(BAR_DIR, 'yandexuid_top_sites')
CRYPTA_ID_BAR_TOP_SITES = join(BAR_DIR, 'crypta_id_top_sites')

BAR_HOST_APP_SESSIONS_DIRECTORY = join(BAR_DIR, 'host_app_sessions')
BAR_SITE_COUNTER_TABLE = join(BAR_DIR, 'site_counter')
BAR_VECTORS_TABLE = join(BAR_DIR, 'vectors')

# external profiles
EXTERNAL_PROFILES_YT_DIRECTORY = join(PROFILES_YT_DIRECTORY, 'external-profiles')

SOCIALDB_DATA_STORAGE_FOLDER = join(EXTERNAL_PROFILES_YT_DIRECTORY, 'socialdb-data')
DIT_DATA_STORAGE_FOLDER = join(EXTERNAL_PROFILES_YT_DIRECTORY, 'dit-data')
DIT_ATTRS_ACCUMULATOR = join(DIT_DATA_STORAGE_FOLDER, 'attrs')
DIT_EMAILS_ACCUMULATOR = join(DIT_DATA_STORAGE_FOLDER, 'emails')
DIT_PHONES_ACCUMULATOR = join(DIT_DATA_STORAGE_FOLDER, 'phones')
DIT_INFO_TABLE = join(DIT_DATA_STORAGE_FOLDER, 'all_info')

SOCDEM_RAW_STORAGE_YT_DIR = join(EXTERNAL_PROFILES_YT_DIRECTORY, 'raw-sources')
SOCDEM_STORAGE_YT_DIR = join(EXTERNAL_PROFILES_YT_DIRECTORY, 'sources')
SOCDEM_VALIDATION_DIR = join(EXTERNAL_PROFILES_YT_DIRECTORY, 'validation')
SOCDEM_STORAGE_TABLE = join(EXTERNAL_PROFILES_YT_DIRECTORY, 'socdem_storage')
YANDEXUID_SOCDEM_STORAGE_TABLE = join(EXTERNAL_PROFILES_YT_DIRECTORY, 'yandexuid_socdem_storage')
CRYPTA_ID_SOCDEM_STORAGE_TABLE = join(EXTERNAL_PROFILES_YT_DIRECTORY, 'crypta_id_socdem_storage')
SOLOMON_SOCDEM_STORAGE_SERVICE = 'socdem_storage'
SOLOMON_SOCDEM_VALIDATION_SERVICE = 'socdem_validation'

# segments
SEGMENT_FOLDER = join(PROFILES_YT_DIRECTORY, 'segments')

DAY_PROCESSORS_OUTPUT_FOLDER = join(SEGMENT_FOLDER, 'day_processors_outputs')
LOG_PROCESSORS_OUTPUT_FOLDER = join(SEGMENT_FOLDER, 'log_processors_outputs')
SEGMENT_RAW_OUTPUT_FOLDER = join(SEGMENT_FOLDER, 'raw_output')
SEGMENT_EXTERNAL_DATA_FOLDER = join(SEGMENT_FOLDER, 'external_data')
LAL_SAMPLE_FOLDER = join(SEGMENT_FOLDER, 'lal_samples')
LONG_TERM_DATA_FOLDER = join(SEGMENT_FOLDER, 'long_term_data')
CUSTOM_ML_FOLDER = join(SEGMENT_FOLDER, 'custom_ml')

ALL_PHONE_MODELS_FROM_APPMETRICA = join(LONG_TERM_DATA_FOLDER, 'all_phone_models_from_appmetrica')
PHONE_MODELS_BY_PRICE_SEGMENT = join(LONG_TERM_DATA_FOLDER, 'phone_models_by_price_segment')
PHONE_MODELS_LEMMAS_BY_PRICE_SEGMENT = join(LONG_TERM_DATA_FOLDER, 'phone_models_lemmas_by_price_segment')
PROCESSED_ONLINE_PURCHASES = join(LONG_TERM_DATA_FOLDER, 'online_purchases')
MOBILE_GAMERS_DEVIDS = join(LONG_TERM_DATA_FOLDER, 'mobile_gamers')
ORGANIZATION_CATEGORIES = join(LONG_TERM_DATA_FOLDER, 'organization_categories')

COMMON_LAL_SAMPLES_FOLDER = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'common_lal_samples')

# interests
SHORTTERM_INTERESTS_INPUT_YT_DIRECTORY = join(PROFILES_INPUT_YT_DIRECTORY, 'shortterm-interests')
INTERESTS_FOLDER = join(SEGMENT_FOLDER, 'interests')
INTERESTS_TO_BIGB_RAW_FOLDER = join(INTERESTS_FOLDER, 'export/to_bigb_raw')
INTERESTS_TO_BIGB_FOLDER = SHORTTERM_INTERESTS_INPUT_YT_DIRECTORY
INTERESTS_PROCESSED_FOLDER = join(INTERESTS_FOLDER, 'processed')
INTERESTS_MERGED_FOLDER = join(INTERESTS_FOLDER, 'merged')
INTERESTS_LONGTERM_FOLDER = join(INTERESTS_FOLDER, 'longterm')

CATALOGIA_TO_INTERESTS_BIGB_MAPPING_TABLE = join(PROFILES_YT_DIRECTORY, 'export/catalogia_to_interests')

# matching
PROFILES_MATCHING_DIR = join(PROFILES_YT_DIRECTORY, 'matching')

CRYPTAID_YANDEXUID_TABLE = join(PROFILES_MATCHING_DIR, 'cryptaid_yandexuid')
YANDEXUID_CRYPTAID_TABLE = join(PROFILES_MATCHING_DIR, 'yandexuid_cryptaid')
DEVID_CRYPTAID_TABLE = join(PROFILES_MATCHING_DIR, 'devid_cryptaid')

# sample
PROFILES_SAMPLE_YT_DIRECTORY = join(PROFILES_YT_DIRECTORY, 'sample')

SAMPLE_WEIGHTS_TABLE = join(PROFILES_SAMPLE_YT_DIRECTORY, 'sample_weights')

SOCDEM_LABELS_FOR_LEARNING_TABLE = join(PROFILES_SAMPLE_YT_DIRECTORY, 'socdem_labels_for_learning')
SOCDEM_LABELS_TABLE = join(PROFILES_SAMPLE_YT_DIRECTORY, 'socdem_labels')

EMAIL_GENDER_TRAINING_SAMPLE_TABLE = join(PROFILES_SAMPLE_YT_DIRECTORY, 'email_gender_training_sample')

# socdem
PROFILES_SOCDEM_YT_DIRECTORY = join(PROFILES_YT_DIRECTORY, 'socdem')
SOCDEM_TRAINING_SAMPLE_TABLE = join(PROFILES_SOCDEM_YT_DIRECTORY, 'plain_training_sample')

# datalens
DATALENS_SOCDEM_YT_DIRECTORY = join(PROFILES_SOCDEM_YT_DIRECTORY, 'datalens')
PRISM_DIRECTORY = join(CRYPTA_YT_WORKING_DIR, 'prism')
DATALENS_PRISM_DIRECTORY = join(PRISM_DIRECTORY, 'datalens')

DATALENS_SOCDEM_INCOME_THRESHOLDS_TABLE = join(DATALENS_SOCDEM_YT_DIRECTORY, 'income_thresholds')
DATALENS_SOCDEM_CLASSIFICATION_THRESHOLDS_TABLE = join(DATALENS_SOCDEM_YT_DIRECTORY, 'classification_thresholds')
DATALENS_SOCDEM_VALIDATION_TABLE = join(DATALENS_SOCDEM_YT_DIRECTORY, 'validation')
DATALENS_PRISM_PRODUCTION_METRICS_TABLE = join(DATALENS_PRISM_DIRECTORY, 'production_metrics')

# classification thresholds
THRESHOLDS_FOLDER = join(EXTERNAL_PROFILES_YT_DIRECTORY, 'classification_thresholds')
HISTOGRAMS_DIRECTORY = join(THRESHOLDS_FOLDER, 'histograms')
CLASSIFICATION_THRESHOLDS_TABLE = join(THRESHOLDS_FOLDER, 'thresholds')

# income
SOLOMON_SOCDEM_SOURCES_SERVICE = 'socdem_sources'
INCOME_FOLDER = join(EXTERNAL_PROFILES_YT_DIRECTORY, 'income')
INCOME_THRESHOLDS_TABLE = join(INCOME_FOLDER, 'thresholds')
PARSED_JOB_SEARCH_FOLDER = join(INCOME_FOLDER, 'parsed_job_search')
MERGED_JOB_SEARCH_TABLE = join(INCOME_FOLDER, 'merged_job_search')
SCORING_FOLDER = join(INCOME_FOLDER, 'data_by_scoring')
TELECOMS_FOLDER = join(INCOME_FOLDER, 'telecoms')
MERGED_AUTO_RU_TABLE = join(INCOME_FOLDER, 'merged_auto_ru')
AUTO_RU_CREDIT_APPLICATIONS_DAILY_FOLDER = '//home/verticals/broker/prod/warehouse/shark/credit_application_event/1d'

# internal export
PROFILES_INTERNAL_EXPORT_YT_DIRECTORY = join(PROFILES_YT_DIRECTORY, 'internal-export')

VISITED_SITES_FOR_DIT_DIRECTORY = join(PROFILES_INTERNAL_EXPORT_YT_DIRECTORY, 'dit')

YANDEXUID_LOGBROKER_EXPORT_YT_DIRECTORY = join(PROFILES_INTERNAL_EXPORT_YT_DIRECTORY, 'logbroker/yandexuid-profiles')
CRYPTA_ID_LOGBROKER_EXPORT_YT_DIRECTORY = join(PROFILES_INTERNAL_EXPORT_YT_DIRECTORY, 'logbroker/cryptaid-profiles')

PROFILES_COLLECTOR_EXPORT_YT_DIRECTORY = join(PROFILES_INTERNAL_EXPORT_YT_DIRECTORY, 'bigb-collector/profiles/fresh')
SHORTTERM_INTERESTS_COLLECTOR_EXPORT_YT_DIRECTORY = join(PROFILES_INTERNAL_EXPORT_YT_DIRECTORY, 'bigb-collector/shortterm-interests/fresh')

# word stats
REQANS_WORDS_STATS_DIRECTORY = join(PROFILES_INTERNAL_EXPORT_YT_DIRECTORY, 'reqans_words')
FLATTENED_REQANS_WORDS_DIRECTORY = join(REQANS_WORDS_STATS_DIRECTORY, 'daily_flattened_words')

YANDEXUID_WORD_WEIGHTS_TABLE = join(REQANS_WORDS_STATS_DIRECTORY, 'yandexuid_word_weights')
CRYPTA_ID_WORD_WEIGHTS_TABLE = join(REQANS_WORDS_STATS_DIRECTORY, 'crypta_id_word_weights')

CRYPTA_ID_WORDS_TABLE = join(REQANS_WORDS_STATS_DIRECTORY, 'crypta_id_words')
YANDEXUID_WORDS_TABLE = join(REQANS_WORDS_STATS_DIRECTORY, 'yandexuid_words')

# affinity
PRECALCULATED_AFFINITY_DIRECTORY = join(PROFILES_INTERNAL_EXPORT_YT_DIRECTORY, 'affinity')

YANDEXUID_REQANS_WORDS_AFFINITY = join(PRECALCULATED_AFFINITY_DIRECTORY, 'reqans_yandexuid_words_affinity')
CRYPTA_ID_REQANS_WORDS_AFFINITY = join(PRECALCULATED_AFFINITY_DIRECTORY, 'reqans_crypta_id_words_affinity')

YANDEXUID_HOSTS_AFFINITY = join(PRECALCULATED_AFFINITY_DIRECTORY, 'yandexuid_hosts_weights')
CRYPTA_ID_HOSTS_AFFINITY = join(PRECALCULATED_AFFINITY_DIRECTORY, 'crypta_id_hosts_weights')

# logbroker send logs
YANDEXUID_PROFILES_LOGS_DIRECTORY = join(PROFILES_YT_DIRECTORY, 'logs/yandexuid_profiles')
CRYPTA_ID_PROFILES_LOGS_DIRECTORY = join(PROFILES_YT_DIRECTORY, 'logs/crypta_id_profiles')

AUDIENCE_API_LOGS_DIRECTORY = join(PROFILES_YT_DIRECTORY, 'logs/audience-api')
CRYPTAID_AUDIENCE_API_LOGS_DIRECTORY = join(PROFILES_YT_DIRECTORY, 'logs/cryptaid-audience-api')

LOCAL_STORAGE_DIRECTORY = '/mnt/data_volume/site2vec'

# site2vec retrain
LOCAL_WORD2VEC_BIN = '/usr/share/crypta/profile/contrib/word2vec_with_start_vectors/bin/word2vec'

SESSIONS_LOCAL_DIRECTORY = join(LOCAL_STORAGE_DIRECTORY, 'sessions')
VOCABULARY_LOCAL_DIRECTORY = join(LOCAL_STORAGE_DIRECTORY, 'vocabulary')
VECTORS_LOCAL_DIRECTORY = join(LOCAL_STORAGE_DIRECTORY, 'vectors')

# local logs
LOCAL_LOGS_DIRECTORY = join(LOCAL_STORAGE_DIRECTORY, 'logs')
TASKS_LOGS_DIRECTORY = join(LOCAL_LOGS_DIRECTORY, 'tasks')
TIMESTAMP_TASKS_LOGS_DIRECTORY = join(LOCAL_LOGS_DIRECTORY, 'timestamp_tasks')

# export
PROFILES_EXPORT_YT_DIRECTORY = join(PROFILES_YT_DIRECTORY, 'export')
YANDEXUID_DAILY_EXPORT_DIRECTORY = join(PROFILES_EXPORT_YT_DIRECTORY, 'daily-export')
CRYPTAID_DAILY_EXPORT_DIRECTORY = join(PROFILES_EXPORT_YT_DIRECTORY, 'daily-export-cryptaid')
YANDEXUID_PROFILES_EXPORT_DIRECTORY = join(PROFILES_EXPORT_YT_DIRECTORY, 'yandexuid')
CRYPTAID_PROFILES_EXPORT_DIRECTORY = join(PROFILES_EXPORT_YT_DIRECTORY, 'cryptaid')
YANDEXUID_EXPORT_PROFILES_14_DAYS_TABLE = join(PROFILES_EXPORT_YT_DIRECTORY, 'profiles_for_14days')
CRYPTAID_EXPORT_PROFILES_14_DAYS_TABLE = join(PROFILES_EXPORT_YT_DIRECTORY, 'cryptaid_profiles_for_14days')

DEVID_PROFILES_EXPORT_TABLE = join(PROFILES_EXPORT_YT_DIRECTORY, 'devid_profiles')

LAB_SEGMENTS_INFO_TABLE = join(PROFILES_EXPORT_YT_DIRECTORY, 'lab/segments')

PROFILES_EXPORT_VECTORS_YT_DIRECTORY = join(PROFILES_EXPORT_YT_DIRECTORY, 'vectors')

SITE2VEC_VECTORS_TABLE = join(PROFILES_EXPORT_VECTORS_YT_DIRECTORY, 'site2vec')
APP2VEC_VECTORS_TABLE = join(PROFILES_EXPORT_VECTORS_YT_DIRECTORY, 'app2vec')
SITE2VEC_APP2VEC_VECTORS_TABLE = join(PROFILES_EXPORT_VECTORS_YT_DIRECTORY, 'site2vec_app2vec_in_the_same_dimension')

SITE2VEC_APP2VEC_VECTORS_FOLDER = join(PROFILES_EXPORT_VECTORS_YT_DIRECTORY, 'site2vec_app2vec_in_the_same_dimension_by_dates')

DAILY_YANDEXUID2VEC = join(PROFILES_EXPORT_VECTORS_YT_DIRECTORY, 'yandexuid_vectors_daily')
MONTHLY_YANDEXUID2VEC = join(PROFILES_EXPORT_VECTORS_YT_DIRECTORY, 'yandexuid_vectors_monthly')
MONTHLY_CRYPTAID2VEC = join(PROFILES_EXPORT_VECTORS_YT_DIRECTORY, 'crypta_id_vectors_monthly')
ALL_MONTHLY_CRYPTAID2VEC = join(PROFILES_EXPORT_VECTORS_YT_DIRECTORY, 'all_crypta_id_vectors_monthly')

DAILY_DEVID2VEC = join(PROFILES_EXPORT_VECTORS_YT_DIRECTORY, 'devid_vectors_daily')
MONTHLY_DEVID2VEC = join(PROFILES_EXPORT_VECTORS_YT_DIRECTORY, 'devid_vectors_monthly')

PACKED_VECTORS_TABLE = join(PROFILES_EXPORT_VECTORS_YT_DIRECTORY, 'packed_vectors')

SOLOMON_SOCDEM_DISTRIBUTIONS_SERVICE = 'socdem_distributions'

# parts
PROFILES_PARTS_YT_DIRECTORY = join(PROFILES_YT_DIRECTORY, 'parts')
PROFILES_SEGMENT_PARTS_YT_DIRECTORY = join(PROFILES_YT_DIRECTORY, 'segment_parts')
YANDEX_LOYALTY_TABLE = join(PROFILES_PARTS_YT_DIRECTORY, 'yandex_loyalty')

# affinitive and top sites
AFFINITIVE_AND_TOP_SITES_DIRECTORY = join(PROFILES_INTERNAL_EXPORT_YT_DIRECTORY, 'affinitive_and_top_sites')

YANDEXUID_AFFINITIVE_AND_COMMON_TOP_SITES_DIRECTORY = join(AFFINITIVE_AND_TOP_SITES_DIRECTORY, 'yandexuid')
CRYPTA_ID_AFFINITIVE_AND_COMMON_TOP_SITES_DIRECTORY = join(AFFINITIVE_AND_TOP_SITES_DIRECTORY, 'crypta_id')
YANDEXUID_TOP_SITE_DICT_TABLE = join(PROFILES_EXPORT_YT_DIRECTORY, 'top_site_dict')
CRYPTA_ID_TOP_SITE_DICT_TABLE = join(PROFILES_EXPORT_YT_DIRECTORY, 'top_site_dict_crypta_id')
YANDEXUID_SITE_DICT_TABLE = join(PROFILES_EXPORT_YT_DIRECTORY, 'site_dict')
CRYPTA_ID_SITE_DICT_TABLE = join(PROFILES_EXPORT_YT_DIRECTORY, 'site_dict_crypta_id')

# stages
PROFILES_STAGES_YT_DIRECTORY = join(PROFILES_YT_DIRECTORY, 'stages')

ADDITIONAL_YANDEXUID_ATTRIBUTES_DIRECTORY = join(PROFILES_STAGES_YT_DIRECTORY, 'yandexuid-with-attrs')

RAW_YANDEXUID_PROFILES_YT_DIRECTORY = join(PROFILES_STAGES_YT_DIRECTORY, 'raw-yandexuid')
MERGED_RAW_YANDEXUID_PROFILES = join(PROFILES_STAGES_YT_DIRECTORY, 'raw_yandexuid_for_14days')

RAW_DEVID_PROFILES_YT_DIRECTORY = join(PROFILES_STAGES_YT_DIRECTORY, 'raw-devid')
MERGED_RAW_DEVID_PROFILES = join(PROFILES_STAGES_YT_DIRECTORY, 'raw_devid_for_35days')

JOINED_YANDEXUID_PROFILES_YT_DIRECTORY = join(PROFILES_STAGES_YT_DIRECTORY, 'joined-yandexuid')

CRYPTA_ID_PROFILES_YT_DIRECTORY = join(PROFILES_STAGES_YT_DIRECTORY, 'cryptaid')
CORRECTED_YANDEXUID_PROFILES_YT_DIRECTORY = join(PROFILES_STAGES_YT_DIRECTORY, 'corrected-yandexuid')
CORRECTED_DEVID_PROFILES_YT_DIRECTORY = join(PROFILES_STAGES_YT_DIRECTORY, 'corrected-devid')
CORRECTED_NOT_ACTIVE_YANDEXUID_PROFILES_YT_DIRECTORY = join(PROFILES_STAGES_YT_DIRECTORY, 'corrected-not-active-yandexuid')
CORRECTED_NOT_ACTIVE_YANDEXUID_PROFILES_WITH_SEGMENTS_YT_DIRECTORY = join(PROFILES_STAGES_YT_DIRECTORY, 'corrected-not-active-yandexuid-with-segments')

MERGED_SEGMENTS_YT_DIRECTORY = join(PROFILES_STAGES_YT_DIRECTORY, 'merged-segments')
DAILY_MERGED_SEGMENTS_BY_ID_YT_DIRECTORY = join(PROFILES_STAGES_YT_DIRECTORY, 'merged-segments/daily-merged-by-id')
SEGMENTS_STORAGE_BY_ID_TABLE_TEMPLATE = join(PROFILES_STAGES_YT_DIRECTORY, 'merged-segments/{}_segments_storage_by_id')
SEGMENTS_STORAGE_BY_ID_WITH_CRYPTA_ID_TABLE = join(PROFILES_STAGES_YT_DIRECTORY, 'merged-segments/segments_storage_by_id_with_crypta_id')
EXPANDED_SEGMENTS_STORAGE_BY_CRYPTA_ID_TABLE = join(PROFILES_STAGES_YT_DIRECTORY, 'merged-segments/expanded_segments_storage_by_crypta_id')
EXPANDED_SEGMENTS_STORAGE_BY_YANDEXUID_TABLE = join(PROFILES_STAGES_YT_DIRECTORY, 'merged-segments/expanded_segments_storage_by_yandexuid')
EXPANDED_INDEVICE_SEGMENTS_STORAGE_BY_YANDEXUID_TABLE = join(PROFILES_STAGES_YT_DIRECTORY, 'merged-segments/expanded_indevice_segments_storage_by_yandexuid')
SEGMENTS_STORAGE_BY_YANDEXUID_TABLE = join(PROFILES_STAGES_YT_DIRECTORY, 'merged-segments/segments_storage_by_yandexuid')

DAILY_STANDARD_HEURISTIC_DIRECTORY = join(SEGMENT_FOLDER, 'standard_heuristic_daily')
DAILY_ADDITION_STANDARD_HEURISTIC_DIRECTORY = join(SEGMENT_FOLDER, 'standard_heuristic_daily_addition')
AGGREGATED_STANDARD_HEURISTIC_DIRECTORY = join(SEGMENT_FOLDER, 'standard_heuristic_aggregated')
STANDARD_HEURISTIC_RESULT_TABLE = join(PROFILES_SEGMENT_PARTS_YT_DIRECTORY, 'standard_heuristic')

# efir
VIDEO_SESSIONS_LOG_DIRECTORY = '//home/videoquality/vh_analytics/strm_cube_2'

SUBSCRIBERS_CUBE = '//home/msdata/user-profiles/v1'

# custom ml segments
SOLOMON_CRYPTA_ML_PROJECT = 'crypta-ml'
SOLOMON_TRAINABLE_SEGMENTS_SERVICE = 'trainable_segments'
CATEGORICAL_FEATURES_CUSTOM_ML_MATCHING_DIR = join(CUSTOM_ML_FOLDER, 'categorical_features')
CATBOOST_FEATURES_TABLE = join(CUSTOM_ML_FOLDER, 'catboost_features')

# custom classification
TRAINABLE_SEGMENTS_PRIORITIES = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'priorities')
BED_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'bed', 'sample_by_puid')
BED_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'bed', 'sample_by_yuid')
BNPL_SCORING_BY_ID = '//home/mlp/export/saturn/bnpl_external/prod'
CASH_SETTLEMENT_SERVICES_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'cash_settlement_services', 'sample_by_puid')
CASH_SETTLEMENT_SERVICES_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'cash_settlement_services', 'sample_by_yuid')
COSMETICS_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'cosmetics', 'sample_by_puid')
COSMETICS_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'cosmetics', 'sample_by_yuid')
CREDIT_CARD_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'credit_card', 'sample_by_puid')
CREDIT_CARD_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'credit_card', 'sample_by_yuid')
CUSTOM_INCOME_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'custom_income', 'income_by_puid')
CUSTOM_INCOME_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'custom_income', 'income_by_yuid')
EBOOK_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'ebook', 'sample_by_puid')
EBOOK_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'ebook', 'sample_by_yuid')
DATING_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'dating', 'sample_by_puid')
DATING_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'dating', 'sample_by_yuid')
ELECTRONIC_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'electronic', 'sample_by_puid')
ELECTRONIC_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'electronic', 'sample_by_yuid')
ENGLISH_ONLINE_EDUCATION_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'english_online_education', 'sample_by_puid')
ENGLISH_ONLINE_EDUCATION_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'english_online_education', 'sample_by_yuid')
FOOD_DELIVERY_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'food_delivery', 'sample_by_puid')
FOOD_DELIVERY_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'food_delivery', 'sample_by_yuid')
FURNITURE_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'furniture', 'sample_by_puid')
FURNITURE_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'furniture', 'sample_by_yuid')
GAME_LOGIN_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'game_login', 'sample_by_puid')
GAME_LOGIN_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'game_login', 'sample_by_yuid')
GENERIC_CAR_CREDIT_APPROVAL_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'generic_car_credit_approval', 'sample_by_puid')
GENERIC_CAR_CREDIT_APPROVAL_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'generic_car_credit_approval', 'sample_by_yuid')
GENERIC_CREDIT_APPROVAL_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'generic_credit_approval', 'sample_by_puid')
GENERIC_CREDIT_APPROVAL_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'generic_credit_approval', 'sample_by_yuid')
GENERIC_INSURANCE_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'generic_insurance', 'sample_by_puid')
GENERIC_INSURANCE_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'generic_insurance', 'sample_by_yuid')
GENERIC_MICROFINANCE_APPROVAL_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'generic_microfinance_approval', 'sample_by_puid')
GENERIC_MICROFINANCE_APPROVAL_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'generic_microfinance_approval', 'sample_by_yuid')
GENERIC_SCORING_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'generic_scoring', 'sample_by_puid')
GENERIC_SCORING_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'generic_scoring', 'sample_by_yuid')
GROCERY_DELIVERY_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'grocery_delivery', 'sample_by_puid')
GROCERY_DELIVERY_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'grocery_delivery', 'sample_by_yuid')
HEALTHY_FOOD_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'healthy_food', 'sample_by_puid')
HEALTHY_FOOD_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'healthy_food', 'sample_by_yuid')
HOME_DEPOT_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'home_depot', 'sample_by_puid')
HOME_DEPOT_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'home_depot', 'sample_by_yuid')
HOTEL_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'hotel', 'sample_by_puid')
HOTEL_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'hotel', 'sample_by_yuid')
INVESTMENT_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'investment', 'sample_by_puid')
INVESTMENT_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'investment', 'sample_by_yuid')
LEGAL_ENTITIES_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'legal_entities', 'sample_by_puid')
LEGAL_ENTITIES_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'legal_entities', 'sample_by_yuid')
LEGAL_OFFICE_VISITS_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'legal_office_visits', 'sample_by_puid')
LEGAL_OFFICE_VISITS_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'legal_office_visits', 'sample_by_yuid')
MARKET_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'market_classification', 'questionnaire_sample_by_puid')
MARKET_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'market_classification', 'questionnaire_sample_by_yuid')
MARKET_RFM_STORAGE = '//home/market/production/analytics/acquisition_and_retention/targets_obuchaemye_segmenty/targets'
MARKET_RFM_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'market_rfm_classification', 'sample_by_yuid')
MARRIAGE_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'tv_marriage_questionnaire', 'marriage_by_puid')
MARRIAGE_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'tv_marriage_questionnaire', 'marriage_by_yuid')
MEDICAL_CLINIC_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'medical_clinic', 'sample_by_puid')
MEDICAL_CLINIC_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'medical_clinic', 'sample_by_yuid')
MORTGAGE_APPROVAL_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'mortgage_approval', 'sample_by_puid')
MORTGAGE_APPROVAL_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'mortgage_approval', 'sample_by_yuid')
ONLINE_CINEMA_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'online_cinema', 'sample_by_puid')
ONLINE_CINEMA_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'online_cinema', 'sample_by_yuid')
ONLINE_PAYMENT_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'online_payment', 'sample_by_puid')
ONLINE_PAYMENT_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'online_payment', 'sample_by_yuid')
ONLINE_SALES_REGISTER_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'online_sales_register', 'sample_by_puid')
ONLINE_SALES_REGISTER_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'online_sales_register', 'sample_by_yuid')
ONLINE_SHOPPING_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'online_shopping', 'sample_by_puid')
ONLINE_SHOPPING_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'online_shopping', 'sample_by_yuid')
PHARMACY_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'pharmacy', 'sample_by_puid')
PHARMACY_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'pharmacy', 'sample_by_yuid')
REALTY_VISIT_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'realty_visit', 'sample_by_puid')
REALTY_VISIT_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'realty_visit', 'sample_by_yuid')
TV_VIEWERS_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'tv_marriage_questionnaire', 'tv_viewers_by_puid')
TV_VIEWERS_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'tv_marriage_questionnaire', 'tv_viewers_by_yuid')
WINDOWS_INSTALLATION_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'windows_installation', 'sample_by_puid')
WINDOWS_INSTALLATION_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'windows_installation', 'sample_by_yuid')
DEBIT_CARDS_ACTIVATION_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'debit_cards_activation', 'sample_by_puid')
DEBIT_CARDS_ACTIVATION_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'debit_cards_activation', 'sample_by_yuid')

# custom regression
HEAVY_SUITE_TRAIN_SAMPLE_BY_PUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'heavy_suite', 'sample_by_puid')
HEAVY_SUITE_TRAIN_SAMPLE_BY_YUID = join(SEGMENT_EXTERNAL_DATA_FOLDER, 'heavy_suite', 'sample_by_yuid')

# geocube
GEOCUBE_PARSED_DIR = join(PARSED_LOGS_YT_DIRECTORY, 'geocube')

# billing
PUIDS_WITH_CARDS = '//home/balance/prod/trust/bindings/crypta/crypta'

# webmaster
WEBMASTER_PROD = '//home/webmaster/prod/export'

WEBMASTER_VERIFIED_HOSTS_TABLE_TEMPLATE = join(WEBMASTER_PROD, 'archive/webmaster-verified-hosts/webmaster-verified-hosts.{}')
TURBO_HOSTS_TABLE = join(WEBMASTER_PROD, 'turbo/turbo-hosts')
WEBMASTER_LAST_VISIT_TABLE = join(WEBMASTER_PROD, 'archive/user-last-visit')

# direct
DIRECT_HOME_DIRECTORY = '//home/direct'
DIRECT_USERS = join(DIRECT_HOME_DIRECTORY, 'db/users')
DIRECT_GEO = join(DIRECT_HOME_DIRECTORY, 'db/phrases')
DIRECT_BILLING_ORDER_DOMAINS = join(DIRECT_HOME_DIRECTORY, 'export/balance/BillingOrderDomains')
DIRECT_INDUSTRIES = '//home/comdep-analytics/public/client_tiers/fact/latest'
DIRECT_CLIENTS_CUBE = '//statbox/cube/daily/comdep/hypercubes/v1/clients'
DIRECT_CAMPAIGNS_CUBE = '//statbox/cube/daily/comdep/hypercubes/v1/campaigns'

# disk
DISK_ACTIVITY_LOG = '//statbox/heavy-report/disk-audience-actions-v2-short'
DISK_UPLOAD_LOG = '//statbox/heavy-dict/disk-storage-by-users/daily'
DISK_GROUP_SERVICE_MEMBERS = '//home/disk-ps-billing/db_dump/{}/ps-billing-db01/group_service_members'

# homes
USER_HOMES = '//home/user_identification/common/home_index/home/longterm'

# antispam
ANTISPAM_LOG_FOLDER = '//home/antispam/cid'
BRO_IOS_SETTINGS = join(ANTISPAM_LOG_FOLDER, 'metrics/ios_device_history_browser')
PP_IOS_SETTINGS = join(ANTISPAM_LOG_FOLDER, 'metrics/ios_device_history')
PP_ANDROID_SETTINGS = join(ANTISPAM_LOG_FOLDER, 'snapshots/pp_settings_history')

# prism
PRISM_DIR = '//home/prism'
PRISM_OFFLINE_USER_WEIGHTS_DIR = join(PRISM_DIR, 'user_weights')
TRAFFIC_V3_DIR = '//statbox/cube/daily/traffic/v3'

POSTPROCESS_PROFILES_MAPPER_DATA_SIZE_PER_JOB = 200 * 1024 * 1024

# transactions
TRANSACTIONS_FOLDER = join(CRYPTA_YT_WORKING_DIR, 'tx/data')
MARKET_TRANCATIONS = join(TRANSACTIONS_FOLDER, 'market')

TESTING_PARSED_LOGS_DIRECTORY = join(PROFILES_INPUT_YT_DIRECTORY, 'parsed-logs-testing-output')
TESTING_BROKEN_PARSED_LOGS_DIRECTORY = join(TESTING_PARSED_LOGS_DIRECTORY, 'broken')

# siberia
FOR_DESCRIPTION_BY_CRYPTAID_TABLE = '//home/crypta/production/siberia/custom/crypta_id_user_data/by_crypta_id'
SIBERIA_DIR = join(CRYPTA_YT_WORKING_DIR, 'siberia')
CUSTOM_AUDIENCE_DIR = join(SIBERIA_DIR, 'custom_audience')

# sites clustering
SITES_CLUSTERING_DIR = join(CUSTOM_AUDIENCE_DIR, 'sites_clustering')
SITES_CLUSTERING_CENTROIDS_TABLE = join(SITES_CLUSTERING_DIR, 'centroids')
SITES_CLUSTERING_SITES_TABLE = join(SITES_CLUSTERING_DIR, 'sites')
SITES_CLUSTERING_MONTHLY_SITES_DIR = join(SITES_CLUSTERING_DIR, 'monthly_sites')

# site2vec update
SITE2VEC_TABLE = join(PROFILES_EXPORT_VECTORS_YT_DIRECTORY, 'site2vec')
