#!/usr/bin/env python
# -*- coding: utf-8 -*-

from os.path import join


LUIGI_SCHEDULER_URL = 'https://profile.luigi.crypta.yandex.net/'
REACTOR_URL = 'https://reactor.yandex-team.ru'
CRYPTA_YT_WORKING_DIR = '//home/crypta/production'
YT_ACCOUNT = 'crypta-profiles'

SOCDEM_LABELING_ABSOLUTE_THRESHOLDS = {
    'strong': {
        'age': 10.0,
        'gender': 10.0,
        'income': 1.95,
    },
    'weak': {
        'age': 1.7,
        'gender': 1.7,
        'income': 0.95,
    },
}
RELATIVE_THRESHOLD = 0.85

CRYPTA_PUBLIC_IDS_STORAGE_DIR = '//home/crypta/public/ids_storage'
YUID_WITH_ALL_BY_YANDEXUID_TABLE = join(CRYPTA_PUBLIC_IDS_STORAGE_DIR, 'yandexuid/yuid_with_all_light_by_yandexuid')
VERTICES_NO_MULTI_PROFILE = join(CRYPTA_YT_WORKING_DIR, 'state/graph/v2/matching/vertices_no_multi_profile')
VERTICES_NO_MULTI_PROFILE_BY_CRYPTA_ID = join(CRYPTA_YT_WORKING_DIR, 'state/graph/v2/matching/vertices_no_multi_profile_by_crypta_id')
VERTICES_NO_MULTI_PROFILE_BY_ID_TYPE = join(CRYPTA_YT_WORKING_DIR, 'state/graph/v2/matching/vertices_no_multi_profile_by_id_type')
INDEVICE_YANDEXUID_BY_ID_TYPE = join(CRYPTA_YT_WORKING_DIR, 'state/graph/v2/matching/direct_yandexuid_by_id_type_and_id')
INDEVICE_YANDEXUID = join(CRYPTA_YT_WORKING_DIR, 'profiles/matching/indevice_yandexuid')

LOGBROKER_OFFLINE_CRYPTA_IDENT = 'offline-crypta@prod'
LOGBROKER_PROFILES_JSON_LOG_PARTITIONS_NUMBER = 90
LOGBROKER_TESTING_SAMPLING_RATE = None

DEFAULT_POOL = 'crypta_profile_default'
SEGMENTS_POOL = 'crypta_profile_segments'
TRAINABLE_SEGMENTS_POOL = 'crypta_profile_trainable_segments'
MONITORING_POOL = 'crypta_profile_monitorings'
EXPORT_PROFILES_POOL = 'crypta_profile_export'
LOG_PARSER_POOL = 'crypta_profile_log_parser'
INTERESTS_POOL = 'crypta_profile_segments'

N_DAYS_TO_AGGREGATE_APP_DATA = 35

SOLOMON_CLUSTER = 'profile'

CRYPTA_PROFILE_TVM_ID = 2009855

CRYPTA_PROFILES_TOPIC_NAME = '/offline-crypta/crypta-profiles-json-log'

CRYPTA_PROFILE_JUGGLER_HOST = 'crypta.profile.production'
CRYPTA_ML_JUGGLER_HOST = 'crypta.ml.production'

LOG_PARSING_SAMPLING = ''

NUMBER_OF_DAYS_TO_CALCULATE_RULES = 35

INTERESTS_PROCESSED_FOLDER_TTL_DAYS = 40

NUMBER_OF_DAYS_TO_CALCULATE_LONGTERM_INTERESTS = 30
MIN_INTEREST_DURATION_IN_DAYS = 15
