#!/usr/bin/env python
# -*- coding: utf-8 -*-
from crypta.lib.python import secret_manager

from crypta.profile.utils.config.environment import environment


SECRETS = {
    'ROBOT_UNICORN_STAFF_OAUTH': secret_manager.Secret('sec-01csvzjgsc81rdbvzhwz461n3s', 'oauth'),
    'ROBOT_CRYPTA_SANDBOX_OAUTH': secret_manager.Secret('sec-01csvzg7vtpvb7bgrx18ajsscj', 'token'),
    'YA_CRYPTA_AUDIENCE_OAUTH': secret_manager.Secret('sec-01dkvkqcn5gqd4hmq3c48sg0z8', 'oauth'),
    'CLICKHOUSE_PASSWORD': secret_manager.Secret('sec-01edtp80d7a3k5s9dzawggqfd6', 'password'),
    'ROBOT_SECRETARY_OAUTH_TOKEN': secret_manager.Secret('sec-01csvzhx0pk7094n7hkpvd73qt', 'token'),
    'STATBOX_STEP_OAUTH_TOKEN': secret_manager.Secret('sec-01csvzga1x7wnhpvfdcscheeax', 'token'),
    'ROBOT_UNICORN_STATFACE_TOKEN': secret_manager.Secret('sec-01csvzjjzsx8mkbjc132rysp9v', 'token'),
    'SOLOMON_OAUTH': secret_manager.Secret('sec-01e63xgmh8g9fj3c542hrw9vqc', 'token'),

    'UNICORN_AUDIENCE_TVM_SECRET': secret_manager.Secret('sec-01dq7mfsrr2ess7xtrcnm0cvf5', 'client_secret'),     # 2011936
    'CRYPTAIDOR_AUDIENCE_TVM_SECRET': secret_manager.Secret('sec-01ea01np15xqtkf4z0s59j3ajw', 'client_secret'),  # 2020697
}


if environment == 'production':
    SECRETS.update({
        'YT_TOKEN': secret_manager.Secret('sec-01csvzgg3mdasmdygkr5s8n6mz', 'token'),
        'YQL_TOKEN': secret_manager.Secret('sec-01csvzgez8yspn3wmr973hhsqk', 'secret'),
        'CRYPTA_PROFILE_TVM_SECRET': secret_manager.Secret('sec-01dq7m7y6xb50x8h5hheh8b4s0', 'client_secret'),  # 2009855
        'REACTOR_OAUTH': secret_manager.Secret('sec-01ep4xy1ysb2kw1qkxm8nz3n33', 'token'),
    })
else:
    SECRETS.update({
        'YT_TOKEN': secret_manager.Secret('sec-01csvzht1xqae2t7djkh0kjzrm', 'token'),
        'YQL_TOKEN': secret_manager.Secret('sec-01csvzhrwp51f2tm9v8rfv8vkp', 'token'),
        'CRYPTA_PROFILE_TVM_SECRET': secret_manager.Secret('sec-01edwzb1be40d9mg2xy23qs5cw', 'client_secret'),  # 2021516
        'REACTOR_OAUTH': secret_manager.Secret('sec-01ep4xtjts0wfe5hmbq8pwstmm', 'token'),
    })


SECRETS_SINGLETON = None


def get_secrets():
    global SECRETS_SINGLETON
    if SECRETS_SINGLETON:
        return SECRETS_SINGLETON

    SECRETS_SINGLETON = secret_manager.SecretManager(SECRETS)

    return SECRETS_SINGLETON
