import reactor_client

from crypta.profile.lib import date_helpers
from crypta.profile.utils import luigi_utils
from crypta.profile.utils.config import config
from crypta.profile.utils.config.secrets import get_secrets


class ReportProfilesLogCreation(luigi_utils.BaseYtTask):
    priority = 100
    task_group = 'export_profiles'

    def output(self):
        return luigi_utils.YtTableAttributeTarget(
            self.input().table,
            attribute_name='report_to_reactor',
            attribute_value=True,
        )

    def run(self):
        client = reactor_client.ReactorAPIClientV1(
            base_url=config.REACTOR_URL,
            token=get_secrets().get_secret('REACTOR_OAUTH'),
        )

        artifact_id = reactor_client.reactor_objects.ArtifactIdentifier(
            namespace_identifier=reactor_client.reactor_objects.NamespaceIdentifier(
                namespace_path=self.namespace_path
            )
        )

        ypath_meta = reactor_client.reactor_objects.Metadata(
            type_='/yandex.reactor.artifact.YtPathArtifactValueProto',
            dict_obj={
                'cluster': 'hahn',
                'path': self.input().table,
            },
        )

        client.artifact_instance.instantiate(
            artifact_identifier=artifact_id,
            metadata=ypath_meta,
            user_time=date_helpers.from_date_string_to_datetime(
                date_helpers.get_yesterday(self.date),
                date_helpers.DATE_FORMAT,
            ),
            create_if_not_exist=True,
        )

        self.yt.set_attribute(
            self.output().table,
            self.output().attribute_name,
            self.output().attribute_value,
        )
