#!/usr/bin/env python
# -*- coding: utf-8 -*-

from collections import defaultdict

LAL_FIELD_NAMES = [
    'lal_common',
    'lal_internal',
    'lal_private',
]

HEURISTIC_FIELD_NAMES = [
    'heuristic_common',
    'heuristic_internal',
    'heuristic_private',
]

LIST_FIELDS = set(['longterm_interests', 'audience_segments'] + HEURISTIC_FIELD_NAMES)
DICT_FIELDS = set(LAL_FIELD_NAMES + ['probabilistic_segments', 'heuristic_segments', 'marketing_segments',
                                     'shortterm_interests', 'interests_composite'])


def update_if_value_is_bigger(dict1, dict2):
    for key, value in dict2.iteritems():
        if key not in dict1 or dict2[key] > dict1[key]:
            dict1[key] = dict2[key]


def update_inner_dict_if_value_is_bigger(dict1, dict2):
    for key, value in dict2.iteritems():
        if key not in dict1:
            dict1[key] = dict2[key]
        elif dict2[key]['0'] > dict1[key]['0']:
            dict1[key] = dict2[key]


class ProfileBuilder(object):
    @staticmethod
    def combine_segments(rows):
        output_record = {
            'probabilistic_segments': defaultdict(dict),
            'interests_composite': defaultdict(dict),
            'marketing_segments': dict(),
            'heuristic_segments': dict(),

            'lal_internal': dict(),
            'lal_common': dict(),
            'lal_private': dict(),

            'heuristic_common': set(),
            'heuristic_internal': set(),
            'heuristic_private': set(),

            'audience_segments': set(),

            'longterm_interests': set(),
            'shortterm_interests': dict(),
        }

        for row in rows:
            for field_name, field_value in row.iteritems():
                if field_value:
                    if field_name in LIST_FIELDS:
                        output_record[field_name].update(field_value)
                    elif field_name in LAL_FIELD_NAMES or field_name == 'shortterm_interests' or \
                            field_name == 'marketing_segments':
                        update_if_value_is_bigger(output_record[field_name], field_value)
                    elif field_name == 'heuristic_segments':
                        output_record[field_name].update(field_value)
                    elif field_name == 'probabilistic_segments':
                        update_inner_dict_if_value_is_bigger(output_record[field_name], field_value)

        # convert list fields to export format
        for field in LIST_FIELDS:
            if output_record.get(field):
                output_record[field] = list(output_record[field])
            else:
                output_record[field] = None

        # remove empty dicts
        for field in output_record:
            if isinstance(output_record[field], (defaultdict, dict)):
                output_record[field] = dict(output_record[field])

            if not isinstance(output_record[field], (int, long, float, complex)) and not output_record[field]:
                output_record[field] = None

        return output_record
