from crypta.lib.python.word_rule.WordRuleVisitor import WordRuleVisitor


class ExpressionNode(object):
    def __init__(self, operator, operands):
        self.operator = operator
        self.operands = operands

    @staticmethod
    def make_unary(operator, operand):
        return ExpressionNode(operator, [operand])

    @staticmethod
    def make_binary(operator, left, right):
        flattened_operands = []
        for operand in [right, left]:
            if isinstance(operand, ExpressionNode) and operator == operand.operator:
                # Avoid extra allocations
                if flattened_operands:
                    flattened_operands.extend(operand.operands)
                else:
                    flattened_operands = operand.operands
            else:
                flattened_operands.append(operand)

        return ExpressionNode(operator, flattened_operands)


class Visitor(WordRuleVisitor):
    LEAF = "LEAF"

    def __init__(self, process):
        self.process = process

    def visitLemmaExpr(self, ctx):
        return unicode(ctx.value.text)

    def visitParenthesesExpr(self, ctx):
        return self.visit(ctx.expr)

    def visitUnaryExpr(self, ctx):
        return ExpressionNode.make_unary(ctx.op.text, self.visit(ctx.expr))

    def visitBinaryExpr(self, ctx):
        return ExpressionNode.make_binary(ctx.op.text, self.visit(ctx.left), self.visit(ctx.right))

    def visitRoot(self, ctx):
        expr_or_lemma = self.visit(ctx.children[0])
        return self.walk(expr_or_lemma)

    def walk(self, expr_or_lemma):
        if isinstance(expr_or_lemma, basestring):
            return self.process(self.LEAF, expr_or_lemma)
        else:
            return self.process(expr_or_lemma.operator, [
                self.walk(operand)
                for operand in expr_or_lemma.operands
            ])
