#!/usr/bin/env python
# -*- coding: utf-8 -*-

LINEAR_CHECK_LIMIT = 10


class Any(object):
    def __init__(self, *args):
        self.words = set(args)

    def __call__(self, req_words):
        if not req_words:
            return False

        if len(req_words) <= LINEAR_CHECK_LIMIT:
            for word in req_words:
                if word in self.words:
                    return True
            return False

        return len(self.words.intersection(req_words)) > 0

    def __str__(self):
        return "(any of {})".format(' '.join(map(str, self.words)))


class All(object):
    def __init__(self, *args):
        self.words = set(args)

    def __call__(self, req_words):
        if not req_words:
            return False

        if len(req_words) <= LINEAR_CHECK_LIMIT:
            for word in self.words:
                if word not in req_words:
                    return False
            return True

        return len(self.words.intersection(req_words)) == len(self.words)

    def __str__(self):
        return "(all {})".format(' '.join(map(str, self.words)))


class And(object):
    def __init__(self, *args):
        self.filters = args

    def __call__(self, req_words):
        for filter_func in self.filters:
            if not filter_func(req_words):
                return False
        return True

    def __str__(self):
        return "({})".format(' and '.join(map(str, self.filters)))


class Or(object):
    def __init__(self, *args):
        self.filters = args

    def __call__(self, req_words):
        for filter_func in self.filters:
            if filter_func(req_words):
                return True
        return False

    def __str__(self):
        return "({})".format(' or '.join(map(str, self.filters)))


class Not(object):
    def __init__(self, filter_func):
        self.filter_func = filter_func

    def __call__(self, req_words):
        return not self.filter_func(req_words)

    def __str__(self):
        return "(not {})".format(str(self.filter_func))


class AtLeastN(object):
    def __init__(self, n, *args):
        self.n = n
        self.filters = args

    def __call__(self, req_words):
        true_filter_count = 0
        for filter_func in self.filters:
            if filter_func(req_words):
                true_filter_count += 1
            if true_filter_count >= self.n:
                return True
        return False

    def __str__(self):
        return "(at least {} of {})".format(self.n, ' or '.join(map(str, self.filters)))
