#!/usr/bin/python -tt
# -*- coding: utf-8 -*-
from crypta.lib.python.lb_pusher.storage import LBPusher, Batch

from crypta.profile.utils.config import config
from crypta.profile.utils.yt_utils import get_yt_client


MB = 1 << 10 << 10
GB = MB << 10


class MetrikaFriendlyBatch(Batch):
    def __init__(self, batch_size, batch_byte_size):
        super(MetrikaFriendlyBatch, self).__init__(batch_size, batch_byte_size)

    def get(self, with_reset=True):
        result = super(MetrikaFriendlyBatch, self).get(with_reset)
        result += '\n'
        return result


def upload_to_logbroker(
    source_table,
    destination_table,
    logbroker_topic,
    tvm_id,
    tvm_secret,
    n_partitions,
    logbroker_host=None,
    logbroker_port=None,
    yt_data_size_per_job_in_mb=None,
    yt=None,
):

    if not yt:
        yt = get_yt_client()

    with yt.Transaction():
        yt.create_empty_table(
            destination_table,
            schema={
                'status': 'string',
                'count': 'uint64',
            },
        )

        n_simultaneous_jobs = config.LOGBROKER_UPLOAD_JOB_COUNT_MULTIPLIER * n_partitions

        yt.run_map(
            LBPusher(
                logbroker_host or config.LOGBROKER_HOSTNAME,
                logbroker_port or config.LOGBROKER_PORT,
                logbroker_topic,
                tvm_id,
                msg_packer=lambda msg: msg['value'],
                batch_class=MetrikaFriendlyBatch,
            ),
            source_table,
            destination_table,
            spec={
                'data_size_per_job': (yt_data_size_per_job_in_mb or config.LOGBROKER_UPLOAD_BATCH_DATA_SIZE_MEGABYTES) * MB,
                'resource_limits': {'user_slots': n_simultaneous_jobs},
                'max_speculative_job_count_per_task': 0,
                'secure_vault': {'CRYPTA_LBPUSH_TVM_SECRET': tvm_secret},
                'mapper': {'memory_limit': 8 * GB},
            },
        )
