#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging
import os

from crypta.lib.python.logging import logging_helpers
from crypta.profile.lib.yt.client import Yt
from crypta.profile.utils.config import config
from crypta.profile.utils.config.secrets import get_secrets


yt_instances = dict()

logger = logging.getLogger(__name__)
logging_helpers.configure_stdout_logger(logger)


def get_config(pool):
    return {
        'spec_defaults': {
            'pool': pool,
            'owners': list(config.YT_OPERATION_OWNERS),
        },
        'read_parallel': {
            'max_thread_count': 20,
            'data_size_per_thread': 8 * 1024 * 1024,
            'enable': True,
        },
        'pickling': {
            # YTADMIN-4732 брать системный pytz
            'module_filter': lambda module: module and module.__name__ not in (
                'pytz', 'numpy', 'scipy', 'hashlib', 'hmac', 'furl',
            ),
        },
        'create_table_attributes': {
            'compression_codec': 'brotli_3',
            'erasure_codec': 'lrc_12_2_2',
        },
        'remote_temp_tables_directory': config.PROFILES_TMP_YT_DIRECTORY,
    }


def get_yt_client(pool=None, token=None):
    global yt_instances

    pool = pool or config.DEFAULT_POOL
    pid = os.getpid()

    yt_client_id = (pid, pool)

    if yt_client_id in yt_instances:
        yt = yt_instances[yt_client_id]
        return yt

    yt_config = get_config(pool)

    yt = Yt(
        proxy=config.CRYPTA_YT_PROXY,
        token=token or get_secrets().get_secret('YT_TOKEN'),
        config=yt_config,
    )
    yt_instances[yt_client_id] = yt

    return yt
