import datetime

from crypta.lib.python.spine.consts import environment
from crypta.lib.python.spine.juggler import juggler_check_generator
from crypta.lib.python.spine.sandbox import sandbox_scheduler
from sandbox.projects.crypta.common import task


def get_registry():
    juggler = juggler_check_generator.CryptaYtCheckGenerator(tags=["crypta-rmp"], host="crypta-rmp")

    sandbox = sandbox_scheduler.create_default_generator(juggler, tags=["RMP"])
    output_dir = "mobile_app_categories"

    sandbox.create_run_universal_bundle_scheduler(
        bundle_name="make-mobile-app-categories-base-bin",
        cmd=["crypta-rmp-make-mobile-app-categories-base", "--output", output_dir],
        schedule_interval=datetime.timedelta(hours=4),
        kill_timeout=datetime.timedelta(hours=1),
        output_resources=[
            task.OutputResourceConfig(
                type="CryptaMobileAppCategoriesBase",
                path=output_dir,
                attrs={
                    "ttl": 14,
                    "released": environment.STABLE,
                },
            )
        ],
        templates=[],
    ).check(crit_time=datetime.timedelta(hours=12))

    return juggler
