#include <crypta/lib/native/proto_serializer/proto_serializer.h>
#include <crypta/rt_socdem/lib/cpp/model/socdem_evaluator.h>
#include <crypta/rt_socdem/lib/cpp/model/test_utils/utils.h>

#include <library/cpp/resource/resource.h>
#include <library/cpp/yson/node/node_io.h>
#include <library/cpp/testing/benchmark/bench.h>
#include <util/stream/file.h>

using namespace NCrypta::NRtSocdem::NBigb;

namespace {
    const TSocdemModel& GetModel() {
        static const TSocdemModel model = NTestUtils::GetTestModel();
        return model;
    };

    const TVector<NBSYeti::TProfile>& GetProfiles() {
        static TVector<NBSYeti::TProfile> profiles;

        if (profiles.empty()) {
            const auto& rawInput = NResource::Find("/input.yson");
            TMemoryInput input(rawInput);

            const auto rows = NYT::NodeFromYsonStream(&input, NYson::EYsonType::ListFragment).UncheckedAsList();

            ::yabs::proto::Profile profile;
            for (const auto& row: rows) {
                NCrypta::NProtoSerializer::FromString(profile, row["ProfileDump"].AsString());
                profiles.push_back(NTestUtils::ConvertProfile(profile));
            }
        }

        return profiles;
    }
}

Y_CPU_BENCHMARK(SocdemEvaluator, iface) {
    const auto& model = GetModel();
    const auto& profiles = GetProfiles();

    for (const auto i : xrange(iface.Iterations())) {
        TSocdemEvaluator evaluator(model, profiles.at(i % profiles.size()));
        evaluator.GetGender();
        evaluator.GetAge();
        evaluator.GetIncome();
    }
}
