#include "socdem_evaluator.h"
#include "socdem_model.h"

#include <crypta/lib/native/bigb_catboost_applier/catboost_features_calculator.h>
#include <crypta/rt_socdem/lib/cpp/socdem/socdem.h>

#include <google/protobuf/repeated_field.h>
#include <catboost/libs/model/model.h>

#include <library/cpp/iterator/enumerate.h>
#include <library/cpp/iterator/zip.h>
#include <library/cpp/json/json_reader.h>
#include <library/cpp/json/json_value.h>
#include <util/generic/hash.h>
#include <util/generic/maybe.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/stream/file.h>
#include <util/string/join.h>

#include <algorithm>
#include <utility>

using namespace NCrypta;
using namespace NCrypta::NRtSocdem::NBigb;

TSocdemEvaluator::TSocdemEvaluator(const TSocdemModel& model, const NBSYeti::TProfile& profile)
    : Model(model)
    , BigbCatboostApplier(Model.CatboostFeaturesCalculator, profile)
{}

const TBigbCatboostApplierResult& TSocdemEvaluator::GetGender() {
    return Get(Gender, Model.GenderModel, Model.Thresholds.GetGender());
}

const TBigbCatboostApplierResult& TSocdemEvaluator::GetAge() {
    return Get(Age, Model.AgeModel, Model.Thresholds.GetAge());
}

const TBigbCatboostApplierResult& TSocdemEvaluator::GetIncome() {
    return Get(Income, Model.IncomeModel, Model.Thresholds.GetIncome());
}

const TBigbCatboostApplierResult& TSocdemEvaluator::GetIncome3() {
    if (!Income3.Defined()) {
        static const THashMap<size_t, size_t> incomeSegmentMapping({
            {0, 0},
            {1, 1},
            {2, 1},
            {3, 2},
            {4, 2},
        });

        TBigbCatboostApplierResult result;
        const auto& income = GetIncome();
        if (income.Class.Defined()) {
            result.Class = incomeSegmentMapping.at(*income.Class);
        }
        result.Weights.resize(3);

        for (const auto& [income5Segment, weight]: Enumerate(income.Weights)) {
            const auto& income3Segment = incomeSegmentMapping.at(income5Segment);
            result.Weights[income3Segment] += weight;
        }

        Income3 = result;
    }
    return *Income3;
}

bool TSocdemEvaluator::HasAllFeatures(const NBSYeti::TDataFilter& filter) const {
    return Model.CatboostFeaturesCalculator.HasAllFeatures(filter);
}

const TBigbCatboostApplierResult& TSocdemEvaluator::Get(TMaybe<TBigbCatboostApplierResult>& cache, const TFullModel& model, const ::google::protobuf::RepeatedField<double>& thresholds) {
    if (!cache.Defined()) {
        cache = BigbCatboostApplier.Apply(model, thresholds);
    }

    return *cache;
}
