#pragma once

#include "socdem_model.h"

#include <crypta/lib/native/bigb_catboost_applier/bigb_catboost_applier.h>
#include <crypta/rt_socdem/lib/cpp/socdem/socdem.h>

#include <util/generic/maybe.h>

namespace NCrypta::NRtSocdem::NBigb {
    class TSocdemEvaluator {
    public:
        TSocdemEvaluator(const TSocdemModel& model, const NBSYeti::TProfile& profile);

        const TBigbCatboostApplierResult& GetGender();
        const TBigbCatboostApplierResult& GetAge();
        const TBigbCatboostApplierResult& GetIncome();
        const TBigbCatboostApplierResult& GetIncome3();
        bool HasAllFeatures(const NBSYeti::TDataFilter& filter) const;

    private:
        const TBigbCatboostApplierResult& Get(
            TMaybe<TBigbCatboostApplierResult>& cache,
            const TFullModel& model,
            const ::google::protobuf::RepeatedField<double>& thresholds
        );

        const TSocdemModel& Model;

        TBigbCatboostApplier<NBSYeti::TProfile> BigbCatboostApplier;

        TMaybe<TBigbCatboostApplierResult> Gender;
        TMaybe<TBigbCatboostApplierResult> Age;
        TMaybe<TBigbCatboostApplierResult> Income;
        TMaybe<TBigbCatboostApplierResult> Income3;
    };
}
