#include "socdem_model.h"
#include "validate_model.h"

#include <crypta/lib/native/bigb_catboost_applier/proto/catboost_features_mapping.pb.h>
#include <crypta/rt_socdem/proto/thresholds.pb.h>

#include <catboost/libs/model/model.h>
#include <library/cpp/protobuf/json/json2proto.h>

#include <util/folder/path.h>
#include <util/generic/vector.h>
#include <util/stream/file.h>

using namespace NCrypta::NRtSocdem;

NBigb::TSocdemModel NBigb::LoadModelFromFolder(const TString& folder) {
    const auto config = NProtobufJson::TJson2ProtoConfig().SetMapAsObject(true).SetCastFromString(true);

    TFileInput inFeatures(JoinFsPaths(folder, "features_mapping.json"));
    const auto& featuresMapping = NProtobufJson::Json2Proto<NCrypta::TCatboostFeaturesMapping>(inFeatures, config);

    TFileInput inThresholds(JoinFsPaths(folder, "thresholds.json"));
    auto thresholds = NProtobufJson::Json2Proto<TThresholds>(inThresholds, config);

    const auto& rawGenderModelPath = JoinFsPaths(folder, "gender_rt_model.bin");
    auto genderModel = ReadModel(rawGenderModelPath);

    const auto& rawAgeModelPath = JoinFsPaths(folder, "age_rt_model.bin");
    auto ageModel = ReadModel(rawAgeModelPath);

    const auto& rawIncomeModelPath = JoinFsPaths(folder, "income_rt_model.bin");
    auto incomeModel = ReadModel(rawIncomeModelPath);

    TSocdemModel model{
        .GenderModel = std::move(genderModel),
        .AgeModel = std::move(ageModel),
        .IncomeModel = std::move(incomeModel),
        .Thresholds = std::move(thresholds),
        .CatboostFeaturesCalculator = TCatboostFeaturesCalculator(
                {featuresMapping.GetFeatureToIndex().begin(), featuresMapping.GetFeatureToIndex().end()},
                {featuresMapping.GetCounterToPrefix().begin(), featuresMapping.GetCounterToPrefix().end()},
                {featuresMapping.GetKeywordToPrefix().begin(), featuresMapping.GetKeywordToPrefix().end()})
    };
    ValidateModel(model);
    return model;
}
