#include "validate_model.h"

void NCrypta::NRtSocdem::NBigb::ValidateModel(const TSocdemModel& model) {
    Y_ENSURE(model.AgeModel.GetNumFloatFeatures() == model.CatboostFeaturesCalculator.GetNumFloatFeatures());
    Y_ENSURE(model.AgeModel.GetDimensionsCount() == static_cast<size_t>(model.Thresholds.GetAge().size()));

    Y_ENSURE(model.GenderModel.GetNumFloatFeatures() == model.CatboostFeaturesCalculator.GetNumFloatFeatures());
    Y_ENSURE(model.GenderModel.GetDimensionsCount() == static_cast<size_t>(model.Thresholds.GetGender().size()));

    Y_ENSURE(model.IncomeModel.GetNumFloatFeatures() == model.CatboostFeaturesCalculator.GetNumFloatFeatures());
    Y_ENSURE(model.IncomeModel.GetDimensionsCount() == static_cast<size_t>(model.Thresholds.GetIncome().size()));
}
