#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os

from crypta.rt_socdem.lib.python.model.config import environment
from crypta.rt_socdem.lib.python.model.config import (
    production_config,
    testing_config,
)


IS_PRODUCTION = environment.ENVIRONMENT == 'production'

DAYS_BACK_FOR_EFH_HIT_LOG = 5
BM_CATS_COUNTER_ID = 200
BM_CATEGORIES_TO_TAKE = 1000
VALIDATION_SAMPLE_PERCENTAGE = 10
VALIDATION_SAMPLE_REST = 0
OPERATING_SYSTEMS_TO_TAKE = 5
MOBILE_MODELS_TO_TAKE = 50
REGIONS_TO_TAKE = 300
RUSSIA_REGION_ID = 225
THRESHOLDS_ROUND_PRECISION = 3
THRESHOLDS_CONSTANT_FOR_FULL_COVERAGE = 0.1
MAX_THRESHOLDS_POOL_SIZE = 1000000
BIGB_SAMPLING_RATE = 0.003
BIGB_SAMPLING_PERIOD_DAYS = 7

SOCDEM_TYPES = ('gender', 'age_segment', 'income_segment')
YET_ANOTHER_SOCDEM_TYPES = ('gender', 'age', 'income')
SOCDEM_CLASS_KEYWORDS = {
    'offline': {
        'gender': 885,
        'age_segment': 886,
        'income_segment': 888,
    },
    'realtime': {
        'gender': 889,
        'age_segment': 890,
        'income_segment': 892,
    },
}

THRESHOLDS_NEEDED_RECALLS = {
    'gender': [0.5, 0.5],
    'age_segment': [0.08, 0.11, 0.26, 0.22, 0.15, 0.18],
    'income_segment': [0.08, 0.38, 0.38, 0.15, 0.01],
}

SEGMENT_NAMES_BY_SOCDEM_TYPE = {
    'gender': ['m', 'f'],
    'age_segment': ['0_17', '18_24', '25_34', '35_44', '45_54', '55_99'],
    'income_segment': ['A', 'B1', 'B2', 'C1', 'C2'],
}

THRESHOLDS_NAME_BY_SOCDEM_TYPE = {
    'gender': 'Gender',
    'age_segment': 'Age',
    'income_segment': 'Income',
}

BIGB_UDF_URL = 'https://proxy.sandbox.yandex-team.ru/last/BIGB_UDF?attrs={"released":"stable"}'

CRYPTA_YT_WORKING_DIR = \
    production_config.CRYPTA_YT_WORKING_DIR if IS_PRODUCTION else testing_config.CRYPTA_YT_WORKING_DIR

COMMON_TMP_DIRECTORY = '//tmp'
COMMON_YQL_TMP_DIRECTORY = os.path.join(COMMON_TMP_DIRECTORY, 'yql')

PROFILES_DIRECTORY = os.path.join(CRYPTA_YT_WORKING_DIR, 'profiles')
OFFLINE_SOCDEM_DIRECTORY = os.path.join(PROFILES_DIRECTORY, 'socdem')
PROFILES_REALTIME_DIRECTORY = os.path.join(PROFILES_DIRECTORY, 'realtime')
REALTIME_SOCDEM_DIRECTORY = os.path.join(PROFILES_REALTIME_DIRECTORY, 'socdem')
DATALENS_REALTIME_SOCDEM_DIRECTORY = os.path.join(REALTIME_SOCDEM_DIRECTORY, 'datalens')

DATALENS_REALTIME_SOCDEM_ROCAUC_TABLE = os.path.join(DATALENS_REALTIME_SOCDEM_DIRECTORY, 'roc_auc')
DATALENS_REALTIME_SOCDEM_COUNTS_TABLE = os.path.join(DATALENS_REALTIME_SOCDEM_DIRECTORY, 'counts')
DATALENS_REALTIME_SOCDEM_DISTRIBUTIONS_TABLE = os.path.join(DATALENS_REALTIME_SOCDEM_DIRECTORY, 'distributions')
DATALENS_REALTIME_SOCDEM_CLASSIFICATION_THRESHOLDS_TABLE = os.path.join(DATALENS_REALTIME_SOCDEM_DIRECTORY, 'classification_thresholds')

# Realtime socdem training
FEATURES_MAPPING_TABLE = os.path.join(REALTIME_SOCDEM_DIRECTORY, 'features_mapping')
RAW_TRAIN_SAMPLE_TABLE = os.path.join(REALTIME_SOCDEM_DIRECTORY, 'raw_train_sample')
RAW_TRAIN_GENDER_TABLE = os.path.join(REALTIME_SOCDEM_DIRECTORY, 'raw_train_gender')
RAW_TRAIN_AGE_SEGMENT_TABLE = os.path.join(REALTIME_SOCDEM_DIRECTORY, 'raw_train_age_segment')
RAW_TRAIN_INCOME_SEGMENT_TABLE = os.path.join(REALTIME_SOCDEM_DIRECTORY, 'raw_train_income_segment')
CATBOOST_POOL_FILE = os.path.join(REALTIME_SOCDEM_DIRECTORY, 'pool.cd')

THRESHOLDS_DIR = os.path.join(REALTIME_SOCDEM_DIRECTORY, 'thresholds')
THRESHOLDS_FILE = os.path.join(THRESHOLDS_DIR, 'thresholds.json')
THRESHOLDS_POOLS_DIR = os.path.join(THRESHOLDS_DIR, 'pools')
THRESHOLDS_PREDICTIONS_ON_POOLS_DIR = os.path.join(THRESHOLDS_DIR, 'predictions_on_pools')

# Templates
RAW_TRAIN_TEMPLATE_TABLE = os.path.join(REALTIME_SOCDEM_DIRECTORY, 'raw_train_{segment_name}')
CATBOOST_TRAIN_TEMPLATE_TABLE = os.path.join(REALTIME_SOCDEM_DIRECTORY, 'train_{segment_name}_catboost')
CATBOOST_VAL_TEMPLATE_TABLE = os.path.join(REALTIME_SOCDEM_DIRECTORY, 'val_{segment_name}_catboost')
OFFLINE_SOCDEM_TRAINING_SAMPLE_TABLE = os.path.join(OFFLINE_SOCDEM_DIRECTORY, '{}', 'raw_training_sample')

CHEVENT_LOG_DIR = '//statbox/cooked_logs/bs-chevent-cooked-log/v2/1d'
BEH_HIT_LOG_TABLE = '//logs/beh-profile-hit-log/1h/{}T20:00:00'
BEH_REGULAR_HOUR_LOG_DIR = '//logs/beh-profile-regular-log/1h'
BM_CATEGORIES_DESCRIPTION_TABLE = '//home/yabs/dict/BMCategory'
OS_DESCRIPTION_TABLE = '//home/yabs/dict/DetailedDeviceTypeDesc'
