#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging

from statface_client import StatfaceClient

import crypta.lib.python.yql.client as yql_helpers
from crypta.lib.python.yt import yt_helpers
from crypta.rt_socdem.lib.python.model import fields
from crypta.rt_socdem.lib.python.model.config import config

from ads.bsyeti.libs.primitives.counter_proto import counter_ids_pb2
from yabs.server.proto.keywords import keywords_data_pb2

logger = logging.getLogger(__name__)


COUNTERS_TO_FEATURES = {counter_ids_pb2.ECounterId.CI_QUERY_CATEGORIES_INTEREST: fields.BINDINGS}
KEYWORDS_TO_FEATURES = {
    keywords_data_pb2.EKeyword.KW_DEVICE_MODEL_BT: fields.MOBILE_MODELS,
    keywords_data_pb2.EKeyword.KW_DETAILED_DEVICE_TYPE_BT: fields.OPERATING_SYSTEMS,
    keywords_data_pb2.EKeyword.KW_USER_REGION: fields.REGIONS,
}


def get_yt_client(nv_params):
    return yt_helpers.get_yt_client(
        yt_proxy=nv_params['mr-default-cluster'],
        yt_pool=nv_params['yt-pool'],
        yt_token=nv_params['yt-token'],
        yt_prefix=config.REALTIME_SOCDEM_DIRECTORY + '/',
        acl=[
            {
                'subjects': ['crypta-team'],
                'action': 'allow',
                'permissions': ['manage', 'read'],
            },
        ],
        read_parallel={
            'max_thread_count': 20,
            'data_size_per_thread': 8 * 1024 * 1024,
            'enable': True,
        },
        remote_temp_tables_directory=config.COMMON_TMP_DIRECTORY,
    )


def get_yql_client(nv_params):
    return yql_helpers.create_yql_client(
        yt_proxy=nv_params['mr-default-cluster'],
        token=nv_params['yql-token'],
        pool=nv_params['yt-pool'],
        syntax_version=1,
        tmp_folder=config.COMMON_YQL_TMP_DIRECTORY,
    )


def get_statface_client(nv_params):
    return StatfaceClient(
        username='robot-unicorn',
        oauth_token=nv_params['stat-token'].strip(),
        host='upload.stat.yandex-team.ru',
    )
