#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging

from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.rt_socdem.lib.python.model.config import config


logger = logging.getLogger(__name__)

separate_age_gender_income_query = """
$gender_to_index = AsDict(
    ('m', 0),
    ('f', 1),
);

$age_segment_to_index = AsDict(
    ('0_17', 0),
    ('18_24', 1),
    ('25_34', 2),
    ('35_44', 3),
    ('45_54', 4),
    ('55_99', 5),
);

$income_segment_to_index = AsDict(
    ('A', 0),
    ('B1', 1),
    ('B2', 2),
    ('C1', 3),
    ('C2', 4),
);

INSERT INTO `{gender_output_table}`
WITH TRUNCATE

SELECT
    yandexuid,
    crypta_id,
    $gender_to_index[gender] AS gender,
    1.0 AS gender_weight,
    profile,
FROM `{raw_train_sample_table}`
WHERE gender IS NOT NULL
ORDER BY yandexuid;

INSERT INTO `{age_output_table}`
WITH TRUNCATE

SELECT
    yandexuid,
    crypta_id,
    $age_segment_to_index[age_segment] AS age_segment,
    1.0 AS age_segment_weight,
    profile,
FROM `{raw_train_sample_table}`
WHERE age_segment IS NOT NULL
ORDER BY yandexuid;

INSERT INTO `{income_output_table}`
WITH TRUNCATE

SELECT
    yandexuid,
    crypta_id,
    $income_segment_to_index[income_segment] AS income_segment,
    income_segment_weight,
    profile,
FROM `{raw_train_sample_table}`
WHERE income_segment IS NOT NULL
AND income_segment_weight IS NOT NULL
ORDER BY yandexuid;
"""


def separate(
    yt_client,
    yql_client,
    raw_train_sample_table=config.RAW_TRAIN_SAMPLE_TABLE,
    gender_output_table=config.RAW_TRAIN_GENDER_TABLE,
    age_output_table=config.RAW_TRAIN_AGE_SEGMENT_TABLE,
    income_output_table=config.RAW_TRAIN_INCOME_SEGMENT_TABLE,
):
    with NirvanaTransaction(yt_client) as transaction:
        yql_client.execute(
            query=separate_age_gender_income_query.format(
                raw_train_sample_table=raw_train_sample_table,
                gender_output_table=gender_output_table,
                age_output_table=age_output_table,
                income_output_table=income_output_table,
            ),
            transaction=str(transaction.transaction_id),
            title='YQL realtime socdem separate gender, age, income train samples',
        )
