#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging

from crypta.lib.python import templater
from crypta.lib.python.nirvana.nirvana_helpers.nirvana_transaction import NirvanaTransaction
from crypta.rt_socdem.lib.python.model.config import config


logger = logging.getLogger(__name__)

select_raw_train_sample_query = """
INSERT INTO `{{ output_table }}`
WITH TRUNCATE
SELECT
    offline_training_sample.yandexuid AS yandexuid,
    offline_training_sample.crypta_id AS crypta_id,
    offline_training_sample.age_segment AS age_segment,
    offline_training_sample.gender AS gender,
    offline_training_sample.income_segment AS income_segment,
    offline_training_sample.income_segment_weight AS income_segment_weight,
    bb.profile AS profile
FROM (
    SELECT
        UniqID,
        MAX_BY(ProfileDump, `TimeStamp`) AS profile
    FROM LIKE(
        `{{ beh_regular_input_dir }}`,
        `{{ date }}%`
    )
    GROUP BY UniqID
) AS bb
INNER JOIN CONCAT(
    {% for socdem_type_table in socdem_type_tables %}
        `{{ socdem_type_table }}`,
    {% endfor %}
) AS offline_training_sample
ON bb.UniqID == offline_training_sample.yandexuid
ORDER BY yandexuid;
"""


def get(
    yt_client,
    yql_client,
    yesterday,
    beh_regular_input_dir=config.BEH_REGULAR_HOUR_LOG_DIR,
    offline_socdem_training_table=config.OFFLINE_SOCDEM_TRAINING_SAMPLE_TABLE,
    output_table=config.RAW_TRAIN_SAMPLE_TABLE,
):
    with NirvanaTransaction(yt_client) as transaction:
        yql_client.execute(
            query=templater.render_template(
                select_raw_train_sample_query,
                vars={
                    'date': yesterday,
                    'beh_regular_input_dir': beh_regular_input_dir,
                    'socdem_type_tables': [
                        offline_socdem_training_table.format(socdem_type) for socdem_type in config.YET_ANOTHER_SOCDEM_TYPES
                    ],
                    'output_table': output_table,
                },
            ),
            transaction=str(transaction.transaction_id),
            title='YQL realtime socdem select raw train sample',
        )
