#!/usr/bin/env python
# -*- coding: utf-8 -*-

import json
import logging

from crypta.lib.python.yt import yt_helpers
from crypta.rt_socdem.lib.python.model.config import config as model_config


logger = logging.getLogger(__name__)


def get(yt_client, json_input, socdem):
    with open(json_input, 'r') as training_log_file:
        training_log = json.load(training_log_file)

    roc_auc = max(training_log['iterations'], key=lambda elem: elem['test'][1])['test'][1]

    yt_helpers.write_stats_to_yt(
        yt_client=yt_client,
        table_path=model_config.DATALENS_REALTIME_SOCDEM_ROCAUC_TABLE,
        data_to_write={
            'socdem': socdem,
            'roc_auc': roc_auc,
        },
        schema={
            'socdem': 'string',
            'roc_auc': 'double',
        },
    )
