import contextlib
import contextvars
import logging


CTX_CONVERSION_SOURCE_META = contextvars.ContextVar("conversion_source_meta", default=None)


@contextlib.contextmanager
def ctx(meta):
    token = CTX_CONVERSION_SOURCE_META.set(meta)
    try:
        yield token
    finally:
        CTX_CONVERSION_SOURCE_META.reset(token)


class MetaInjectingFilter(logging.Filter):
    def filter(self, record):
        if (meta := CTX_CONVERSION_SOURCE_META.get()) is not None:
            record.meta = {
                "id": str(meta.id),
                "type_code": str(meta.type_code),
                "client_id": str(meta.client_id),
            }

        return True
