from crypta.lib.python.yt import schema_utils
from crypta.s2s.lib.proto.conversion_pb2 import TConversion
from crypta.s2s.lib.proto.conversion_upload_error_pb2 import TConversionUploadError
from crypta.s2s.lib.proto.raw_conversion_parsing_error_pb2 import TRawConversionParsingError


CONVERSIONS_STATE_KEY_COLUMNS = ["Yclid", "GoalId", "Timestamp", "Value", "Currency"]


def get_conversion_schema():
    schema = schema_utils.get_strict_schema(schema_utils.get_schema_from_proto(TConversion))
    schema.attributes["unique_keys"] = False
    return schema


def get_conversion_state_schema():
    schema = schema_utils.get_strict_schema(schema_utils.get_schema_from_proto(TConversion, key_columns=CONVERSIONS_STATE_KEY_COLUMNS))
    schema.attributes["unique_keys"] = True
    return schema


def get_conversion_upload_error_schema():
    schema = schema_utils.get_strict_schema(schema_utils.get_schema_from_proto(TConversionUploadError))
    schema.attributes["unique_keys"] = False
    return schema


def get_raw_conversion_parsing_error_schema():
    schema = schema_utils.get_strict_schema(schema_utils.get_schema_from_proto(TRawConversionParsingError))
    schema.attributes["unique_keys"] = False
    return schema
