from library.python.protobuf.json import (
    json2proto,
    proto2json,
)

from crypta.s2s.lib.proto.download_command_pb2 import TDownloadCommand
from crypta.s2s.lib.proto.process_command_pb2 import TProcessCommand


def serialize_download_command(command):
    return proto2json.proto2json(command)


def deserialize_download_command(serialized_command):
    return _deserialize(serialized_command, TDownloadCommand)


def serialize_process_command(command):
    return proto2json.proto2json(command)


def deserialize_process_command(serialized_command):
    return _deserialize(serialized_command, TProcessCommand)


def _deserialize(serialized_proto, proto_class):
    proto = proto_class()
    json2proto.json2proto(serialized_proto, proto)
    return proto
