import argparse
import logging

from crypta.lib.python import yaml_config
from crypta.lib.python.logging import logging_helpers
from crypta.lib.python.proto_secrets import proto_secrets
from crypta.s2s.services.calc_stats.lib import calculator
from crypta.s2s.services.calc_stats.lib.config_pb2 import TConfig


def parse_args():
    parser = argparse.ArgumentParser(description="Calc s2s stats")
    parser.add_argument("--config", required=True, type=lambda x: yaml_config.parse_config(TConfig, x))
    parser.add_argument("--index", required=True, type=yaml_config.load)
    return parser.parse_args()


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())
    args = parse_args()

    main_func = calculator.run

    logger = logging.getLogger(main_func.__name__)
    logger.info("Config:\n%s", proto_secrets.get_copy_without_secrets(args.config))

    main_func(args.config, logger, args.index)

    logger.info("Completed successfully")
