from yt.wrapper import ypath

from crypta.buchhalter.services.main.lib.common.helpers import tables_helpers
from crypta.lib.python import time_utils
from crypta.lib.python.solomon import reporter
from crypta.lib.python.yql import yql_helpers
from crypta.lib.python.yt import yt_helpers
from crypta.lib.python.yt.processed_tables_tracker import ProcessedTablesTracker
from crypta.s2s.lib import stats_helpers


def run(config, logger, index):
    goal_id_to_client = {
        goal_id: item["client"]
        for item in index
        for goal_id in sum(stats_helpers.get_conversion_name_to_goal_ids(item).values(), start=[])
    }

    goal_id_to_conversion_name = {
        goal_id: conversion_name
        for item in index
        for conversion_name, goal_ids in stats_helpers.get_conversion_name_to_goal_ids(item).items()
        for goal_id in goal_ids
    }

    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)
    tracker = ProcessedTablesTracker(config.BsUniformPostbackLog)
    extra_dirs = [config.BsMobilePostclickLogDir]

    solomon_reporter = reporter.create_solomon_reporter_from_config(config.Solomon)
    logger.info(solomon_reporter)

    yt_client.create("map_node", config.Yt.TmpDir, recursive=True, ignore_existing=True)

    def tmp_table():
        return yt_client.TempTable(config.Yt.TmpDir)

    for tx, date in tables_helpers.unprocessed_dates(yt_client, tracker, extra_dirs, logger):
        with tmp_table() as uniform_postback_stats_table, tmp_table() as mobile_postclick_stats_table:
            bs_uniform_postback_log_table_path = ypath.ypath_join(config.BsUniformPostbackLog.SourceDir, date)

            yql_query_params = {
                "bs_uniform_postback_log": bs_uniform_postback_log_table_path,
                "bs_mobile_postclick_log": ypath.ypath_join(config.BsMobilePostclickLogDir, date),
                "output_uniform_postback_per_goal_id": uniform_postback_stats_table,
                "output_mobile_postclick_per_goal_id": mobile_postclick_stats_table,
            }

            yql_helpers.run_query("/query/calc_stats.yql", config.Yt, yql_query_params, logger, tx)

            dt = time_utils.fromisoformat_moscow(date)

            for table, metric in (
                (uniform_postback_stats_table, Metrics.uniform_postback),
                (mobile_postclick_stats_table, Metrics.mobile_postclick),
            ):
                for item in yt_client.read_table(table):
                    goal_id = item[Fields.goal_id]
                    solomon_reporter.set_value(metric, item[Fields.count], ts_datetime=dt, labels={
                        Labels.goal_id: goal_id,
                        Labels.client: goal_id_to_client.get(goal_id, stats_helpers.SpecialValues.unknown_client),
                        Labels.conversion_name: goal_id_to_conversion_name.get(goal_id, stats_helpers.SpecialValues.unknown_conversion_name),
                    })

            tracker.add_processed_tables(yt_client, [bs_uniform_postback_log_table_path])


class Metrics:
    uniform_postback = "uniform_postback"
    mobile_postclick = "mobile_postclick"


class Labels:
    goal_id = "goal_id"
    client = "client"
    conversion_name = "conversion_name"


class Fields:
    goal_id = "GoalId"
    count = "Count"
