EXECTEST()

OWNER(
    g:crypta
    g:crypta-s2s
)

RUN(
    NAME production_config
    CWD ${ARCADIA_ROOT}/crypta/s2s/services/conversions_downloader/docker/templates

    render_and_check_yaml
        --template config.template.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment": "production"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME stable_config
    CWD ${ARCADIA_ROOT}/crypta/s2s/services/conversions_downloader/docker/templates

    render_and_check_yaml
        --template config.template.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment": "stable"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME testing_config
    CWD ${ARCADIA_ROOT}/crypta/s2s/services/conversions_downloader/docker/templates

    render_and_check_yaml
    --template config.template.yaml
    --output ${TEST_CASE_ROOT}/output.yaml
    --context '{"environment": "testing"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME qa_config
    CWD ${ARCADIA_ROOT}/crypta/s2s/services/conversions_downloader/docker/templates

    render_and_check_yaml
    --template config.template.yaml
    --output ${TEST_CASE_ROOT}/output.yaml
    --context '{"environment": "qa", "yt_proxy": "localhost:1111", "tvm_id": 4444, "download_log_topic": "download-log", "consumer": "consumer", "process_log_topic": "process-log", "logbroker_server": "localhost", "logbroker_port": 1111, "grut_address": "localhost:7777", "solomon_url": "localhost:1234"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

DATA(
    arcadia/crypta/s2s/services/conversions_downloader/docker/templates/config.template.yaml
)

DEPENDS(
    crypta/utils/render_and_check_yaml
)

END()
