import retry

from crypta.lib.python.ftp.client.ftp_client import FtpClient


class FtpDownloader:
    def __init__(self, settings, encrypter, logger):
        self.ftp_client = FtpClient(
            host=settings.host,
            port=settings.port,
            user=settings.login,
            password=encrypter.decrypt(settings.encrypted_password),
            secure=settings.tls,
            timeout=120,
        )
        self.path = settings.path
        self.logger = logger

    @retry.retry(exceptions=(TimeoutError, OSError), tries=5, delay=1, backoff=1.5)
    def download(self, destination_path):
        self.ftp_client.download(self.path, destination_path)
