import csv

import gspread


FIELDNAMES = [
    "id",
    "client_uniq_id",
    "client_ids",
    "emails",
    "phones",
    "emails_md5",
    "phones_md5",
    "create_date_time",
    "order_status",
    "revenue",
    "cost",
]


class GoogleSheetsDownloader:
    def __init__(self, settings, google_api_key, logger):
        self.url = settings.url
        self.google_api_key = google_api_key
        self.logger = logger

    def download(self, destination_path):
        self.logger.info("Process '%s'", self.url)

        google_client = gspread.service_account_from_dict(self.google_api_key, scopes=gspread.auth.READONLY_SCOPES)
        spreadsheet = google_client.open_by_url(self.url)
        worksheet = spreadsheet.get_worksheet(0)

        with open(destination_path, "w") as f:
            writer = csv.DictWriter(f, fieldnames=FIELDNAMES, delimiter=";")
            writer.writeheader()
            writer.writerows(worksheet.get_all_records())
