import requests


class LinkDownloader:
    def __init__(self, settings, logger):
        self.url = settings.url
        self.logger = logger

    def download(self, destination_path):
        response = requests.get(self.url)
        response.raise_for_status()

        with open(destination_path, "wb") as f:
            for chunk in response.iter_content(4096):
                f.write(chunk)
