from crypta.lib.python.sftp.client import SftpClient


class SftpDownloader:
    def __init__(self, settings, encrypter, logger):
        self.sftp_client = SftpClient(
            host=settings.host,
            port=settings.port,
            username=settings.login,
            password=encrypter.decrypt(settings.encrypted_password),
        )
        self.path = settings.path
        self.logger = logger

    def download(self, destination_path):
        with self.sftp_client:
            self.sftp_client.download(self.path, destination_path)
