EXECTEST()

OWNER(
    g:crypta
    g:crypta-s2s
)

RUN(
    NAME stable_config
    CWD ${ARCADIA_ROOT}/crypta/s2s/services/conversions_processor/docker/templates

    render_and_check_yaml
        --template config.template.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment": "production"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME testing_config
    CWD ${ARCADIA_ROOT}/crypta/s2s/services/conversions_processor/docker/templates

    render_and_check_yaml
    --template config.template.yaml
    --output ${TEST_CASE_ROOT}/output.yaml
    --context '{"environment": "testing"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME qa_config
    CWD ${ARCADIA_ROOT}/crypta/s2s/services/conversions_processor/docker/templates

    render_and_check_yaml
    --template config.template.yaml
    --output ${TEST_CASE_ROOT}/output.yaml
    --context '{"environment": "qa", "yt_proxy": "localhost:1111", "tvm_id": 4444, "process_log_topic": "process-log", "consumer": "consumer", "logbroker_server": "localhost", "logbroker_port": 1111, "grut_address": "127.0.0.1:2222", "cdp_api_address": "127.0.0.1:4444", "cdp_api_tvm_id": 11, "max_order_age_days": 10, "max_backup_size": 4, "stats_host": "localhost", "stats_port": 7777}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

DATA(
    arcadia/crypta/s2s/services/conversions_processor/docker/templates/config.template.yaml
)

DEPENDS(
    crypta/utils/render_and_check_yaml
)

END()

