from crypta.lib.python.identifiers.generic_id import GenericID
from crypta.s2s.services.conversions_processor.lib.parsers.parsing_error import ParsingError


class CidParser:
    @staticmethod
    def _parse_generic_cid(id_type, id_value):
        if (cid := GenericID(id_type=id_type, id_value=id_value)).is_valid():
            return cid.normalize

        raise ParsingError(f"Invalid '{id_type}' identifier '{id_value}'")

    @classmethod
    def parse_email(cls, id_value):
        return cls._parse_generic_cid("email", id_value)

    @classmethod
    def parse_phone(cls, id_value):
        return cls._parse_generic_cid("phone", id_value).removeprefix("+")

    @classmethod
    def parse_email_md5(cls, id_value):
        return cls._parse_generic_cid("email_md5", id_value)

    @classmethod
    def parse_phone_md5(cls, id_value):
        return cls._parse_generic_cid("phone_md5", id_value)

    @classmethod
    def parse_client_id(cls, id_value):
        return id_value
