import datetime

from crypta.s2s.services.conversions_processor.lib.parsers.parsing_error import ParsingError


class DateTimeParser:
    date_formats = (
        "%d.%m.%Y",
        "%d.%m.%y",
        "%Y-%m-%d",
    )
    datetime_formats = (
        "%d.%m.%Y %H:%M:%S",
        "%d.%m.%Y %H:%M",
        "%d.%m.%y %H:%M:%S",
        "%d.%m.%y %H:%M",
        "%Y-%m-%d %H:%M:%S",
        "%Y-%m-%d %H:%M",
    )
    min_datetime = datetime.datetime(year=1970, month=1, day=1)

    @classmethod
    def parse(cls, date_string):
        result = cls._parse(date_string)

        if result < cls.min_datetime:
            raise ParsingError(f"Date '{result.isoformat()}' is less than 1970-01-01")

        return result

    @classmethod
    def _parse(cls, date_string):
        for fmt in cls.date_formats:
            try:
                result = datetime.datetime.strptime(date_string, fmt)
                return result.replace(hour=23, minute=59, second=59)
            except ValueError:
                pass

        for fmt in cls.datetime_formats:
            try:
                return datetime.datetime.strptime(date_string, fmt)
            except ValueError:
                pass

        raise ParsingError(f"Invalid date string '{date_string}'")
