import signal

from crypta.lib.python.lb_pusher import logbroker
from crypta.lib.python.lb_pusher.reader_config import ReaderConfig
import crypta.lib.python.tvm.helpers as tvm
from crypta.lib.python.worker_utils.proto_reader import ProtoReader
from crypta.lib.python.worker_utils.stats_server import StatsServer
from crypta.s2s.lib.proto.process_command_pb2 import TProcessCommand
from crypta.s2s.services.conversions_processor.lib.processor.task_queue import TaskQueue
from crypta.s2s.services.conversions_processor.lib.processor.yt_manipulator import YtManipulator


def run(config, logger):
    YtManipulator.from_proto(config, logger).create_directories()

    pq_client = logbroker.PQClient(
        config.Logbroker.Url,
        config.Logbroker.Port,
        tvm_id=config.Tvm.SourceTvmId,
        tvm_secret=config.Tvm.Secret if tvm.get_tvm_test_port() is None else None,  # TODO(kolontaev): workaround. Testing tvm client doesn't work even if after redefinition of tvm id for lb
    )
    pq_reader = pq_client.get_async_reader(ReaderConfig(topic=config.ProcessLogTopic, client_id=config.Consumer, max_count=1, read_only_local=False))
    task_queue = TaskQueue(pq_reader.done_cookies, config)
    stats_server = StatsServer(config.StatsHost, config.StatsPort, task_queue.mp_metric_registry)
    reader = ProtoReader(task_queue.schedule, TProcessCommand)

    signal.signal(signal.SIGTERM, lambda *args: pq_reader.stop())

    stats_server.start()
    with task_queue, pq_client, pq_reader:
        logger.info("Starting loop")
        pq_reader.loop(reader.schedule)
