import collections

from frozendict import frozendict

from crypta.lib.python.worker_utils import task_queue
from crypta.s2s.services.conversions_processor.lib.processor import stats
from crypta.s2s.services.conversions_processor.lib.processor.worker import Worker


class TaskQueue(task_queue.TaskQueue):
    Context = collections.namedtuple("Context", ["config", "processing_metrics"])

    def __init__(self, cookie_queue, config):
        super(TaskQueue, self).__init__(
            cookie_queue=cookie_queue,
            context=None,
            worker_count=config.WorkerCount,
            worker_cls=Worker,
            metrics=stats.get_metrics(),
        )

        processing_metrics = {
            frozendict(labels): stats.ProcessingMetrics(self.mp_metric_registry, labels)
            for labels in stats.get_metrics()
        }

        self.worker_config = self.worker_config._replace(context=self.Context(config, processing_metrics))
