import datetime
import logging

import tvmauth

from crypta.lib.python import grut
import crypta.lib.python.tvm.helpers as tvm
from crypta.lib.python.worker_utils import worker
from crypta.s2s.lib.conversion_source_client import ConversionSourceClient
from crypta.s2s.services.conversions_processor.lib.processor.cdp_api_client import CdpApiClient
from crypta.s2s.services.conversions_processor.lib.processor.processor import Processor
from crypta.s2s.services.conversions_processor.lib.processor.yt_manipulator import YtManipulator


logger = logging.getLogger(__name__)


class Worker(worker.Worker):
    def __init__(self, worker_config):
        super(Worker, self).__init__(worker_config)

        config = worker_config.context.config

        yt_manipulator = YtManipulator.from_proto(config, logger)

        conversion_source_client = ConversionSourceClient(grut.get_client_from_proto(config.Grut), logger)

        tvm_settings = tvmauth.TvmApiClientSettings(
            self_tvm_id=config.Tvm.SourceTvmId,
            self_secret=config.Tvm.Secret,
            dsts={
                CdpApiClient.tvm_alias: config.CdpApiTvmId,
            },
            localhost_port=tvm.get_tvm_test_port(),
        )
        tvm_client = tvmauth.TvmClient(tvm_settings)
        cdp_api_client = CdpApiClient(config.CdpApiAddress, tvm_client, config.LinesPerFile, logger)

        max_order_age = datetime.timedelta(days=config.MaxOrderAgeDays)

        self.processor = Processor(conversion_source_client, yt_manipulator, cdp_api_client, max_order_age, worker_config.context.processing_metrics, logger)

    def execute(self, task, labels):
        self.processor.process(task, labels)
