import datetime
import os

from yt.wrapper import ypath

from crypta.lib.python import time_utils
from crypta.lib.python.yql import yql_helpers
from crypta.lib.python.yt import yt_helpers
from crypta.s2s.lib import schemas


def run(config, logger):
    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)

    yt_client.create("table", config.ConversionsStateTable, ignore_existing=True, attributes={"schema": schemas.get_conversion_schema(), "optimize_for": "scan"})
    yt_client.create("map_node", config.ToPostbackDir, ignore_existing=True)
    yt_client.create("map_node", config.Yt.TmpDir, ignore_existing=True)

    while True:
        with yt_client.Transaction() as tx, yt_client.TempTable(config.Yt.TmpDir) as tmp_output_state_table, yt_client.TempTable(config.Yt.TmpDir) as tmp_to_postback_table:
            fresh_tables = yt_client.list(config.FreshConversionsDir, absolute=True, sort=True)

            if not fresh_tables:
                logger.info("No tables to process")
                break

            fresh_table = fresh_tables[0]

            logger.info("Process table %s", fresh_table)

            last_timestamp_to_keep = time_utils.get_current_time() - int(datetime.timedelta(days=config.StateTtlDays).total_seconds())
            yql_query_params = {
                "fresh_table": fresh_table,
                "state_table": config.ConversionsStateTable,
                "output_state_table": tmp_output_state_table,
                "to_postback_table": tmp_to_postback_table,
                "last_timestamp_to_keep": last_timestamp_to_keep,
            }
            yql_helpers.run_query("/query/process_conversions.yql", config.Yt, yql_query_params, logger, tx=tx)

            yt_client.run_merge(
                tmp_output_state_table,
                config.ConversionsStateTable,
                mode="sorted",
                spec={"force_transform": True, "combine_chunks": True, "merge_by": schemas.CONVERSIONS_STATE_KEY_COLUMNS},
            )

            to_postback_table = ypath.ypath_join(config.ToPostbackDir, os.path.basename(fresh_table))
            yt_client.create("table", to_postback_table, attributes={"schema": schemas.get_conversion_schema(), "optimize_for": "scan"})
            yt_client.run_merge(tmp_to_postback_table, to_postback_table, spec={"force_transform": True, "combine_chunks": True})

            logger.info("Remove table %s", fresh_table)
            yt_client.remove(fresh_table)
