from crypta.lib.python.yt import yt_helpers
from crypta.s2s.services.transfer_conversions_to_yt.lib import (
    google_sheets_provider_runner,
    parsers,
    sftp_provider_runner,
    url_provider_runner,
    yt_provider_runner,
)


def run(config, logger):
    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)
    yt_client.create("map_node", config.FreshConversionsDir, recursive=True, ignore_existing=True)
    yt_client.create("map_node", config.RawBackup.Dir, recursive=True, ignore_existing=True)
    yt_client.create("map_node", config.ParsingErrors.Dir, recursive=True, ignore_existing=True)

    goal_id_source = config.WhichOneof("GoalIdSource")
    logger.info("GoalIdSource name is '%s'", goal_id_source)
    conversion_name_to_goal_ids = {k: v.GoalIds for k, v in config.ConversionNameToGoalIds.Data.items()} if goal_id_source == "ConversionNameToGoalIds" else None
    static_goal_id = config.StaticGoalId if goal_id_source == "StaticGoalId" else None
    parser = parsers.ConversionParser(
        timestamp_range=parsers.get_current_meaningful_timestamp_range(),
        conversion_name_to_goal_ids=conversion_name_to_goal_ids,
        static_goal_id=static_goal_id,
        column_names=config.ColumnNames,
    )

    provider_name = config.WhichOneof("Provider")
    logger.info("Provider name is '%s'", provider_name)

    if provider_name == "UrlProvider":
        provider = config.UrlProvider
        runner_cls = url_provider_runner.UrlProviderRunner
    elif provider_name == "YtProvider":
        provider = config.YtProvider
        runner_cls = yt_provider_runner.YtProviderRunner
    elif provider_name == "SftpProvider":
        provider = config.SftpProvider
        runner_cls = sftp_provider_runner.SftpProviderRunner
    elif provider_name == "GoogleSheetsProvider":
        provider = config.GoogleSheetsProvider
        runner_cls = google_sheets_provider_runner.GoogleSheetsProviderRunner
    else:
        raise Exception("Unknown provider '{}'".format(provider_name))

    runner_cls(
        provider=provider,
        yt_client=yt_client,
        fresh_dir=config.FreshConversionsDir,
        backup_config=config.RawBackup,
        errors_config=config.ParsingErrors,
        parser=parser,
        logger=logger,
    ).run()
