import datetime

from yt.wrapper import ypath

from crypta.lib.python import time_utils
from crypta.lib.python.yt import (
    path_utils,
    yt_helpers,
)
from crypta.lib.python.yt.processed_tables_tracker import ProcessedTablesTracker
from crypta.s2s.services.transfer_conversions_to_yt.lib import helpers


class YtProviderRunner:
    def __init__(
        self,
        provider,
        yt_client,
        fresh_dir,
        backup_config,
        errors_config,
        parser,
        logger,
    ):
        self.provider = provider
        self.yt_client = yt_client
        self.fresh_dir = fresh_dir
        self.backup_config = backup_config
        self.errors_config = errors_config
        self.parser = parser
        self.logger = logger

    def run(self):
        tracker = ProcessedTablesTracker(self.provider.TrackedSource)
        tracker.for_each_unprocessed(self.yt_client, self._handle_table)

    def _handle_table(self, tx, table_path):
        self.logger.info("Process table '%s'", table_path)

        output_table_name = "{}_{}".format(
            path_utils.get_basename(table_path),
            time_utils.get_current_time(),
        )
        backup_table = ypath.ypath_join(self.backup_config.Dir, output_table_name)
        yt_helpers.make_backup_table(table_path, backup_table, ttl_timedelta=datetime.timedelta(days=self.backup_config.TtlDays), yt_client=self.yt_client)

        raw_conversions = self.yt_client.read_table(table_path)
        helpers.upload_to_yt(
            yt_client=self.yt_client,
            raw_conversions=raw_conversions,
            parser=self.parser,
            fresh_table=ypath.ypath_join(self.fresh_dir, output_table_name),
            errors_table=ypath.ypath_join(self.errors_config.Dir, output_table_name),
            errors_ttl=datetime.timedelta(days=self.errors_config.TtlDays),
            logger=self.logger,
        )
