import argparse
import logging

from crypta.s2s.tools.lib import (
    cmd_encrypt,
    cmd_get_conversion_source,
    cmd_parse_csv,
    cmd_reset_last_scheduled_time,
    cmd_upload_to_crm_api,
)
from crypta.lib.python.logging import logging_helpers


def parse_args():
    logging_helpers.configure_stdout_logger(logging.getLogger())
    parser = argparse.ArgumentParser()
    subparsers = parser.add_subparsers()

    cmd_encrypt.add_args_subparser(subparsers)
    cmd_get_conversion_source.add_args_subparser(subparsers)
    cmd_parse_csv.add_args_subparser(subparsers)
    cmd_reset_last_scheduled_time.add_args_subparser(subparsers)
    cmd_upload_to_crm_api.add_args_subparser(subparsers)

    return parser.parse_args()


def main():
    args = parse_args()
    function = args.function
    function_args = dict(vars(args))
    del function_args["function"]
    return function(**function_args)
